"""NlSearch Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum


class NLSearchStatus(str, Enum):
    """NLSearchStatus."""

    COMPLETE = "COMPLETE"
    PARTIAL = "PARTIAL"
    FAILED = "FAILED"


class NLSearchRating(str, Enum):
    """NLSearchRating."""

    THUMBS_UP = "THUMBS_UP"
    THUMBS_DOWN = "THUMBS_DOWN"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NLSearchInputs:
    """NLSearchInputs."""

    query: Optional[str] = field(default=None, metadata=config(field_name="query"))
    limit: Optional[int] = field(default=None, metadata=config(field_name="limit"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NLSearchFeedbackOutput:
    """NLSearchFeedbackOutput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NLSearchOutputs:
    """NLSearchOutputs."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    ql: Optional[str] = field(default=None, metadata=config(field_name="ql"))
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))
    status: Optional[Union[NLSearchStatus, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(NLSearchStatus, x),
            field_name="status",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NLSearchFeedback:
    """NLSearchFeedback."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    feedback_comment: Optional[str] = field(
        default=None, metadata=config(field_name="feedbackComment")
    )
    rating: Optional[Union[NLSearchRating, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(NLSearchRating, x),
            field_name="rating",
        ),
    )
