"""Notebooks Mutation."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.notebooks.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.notebooks import NotebooksService

log = logging.getLogger(__name__)


class TaegisSDKNotebooksMutation:
    """Taegis Notebooks Mutation operations."""

    def __init__(self, service: NotebooksService):
        self.service = service

    def create_notebook(self) -> Notebook:
        """creates a new notebook instance and associated components."""
        endpoint = "createNotebook"

        result = self.service.execute_mutation(
            endpoint=endpoint, variables={}, output=build_output_string(Notebook)
        )
        if result.get(endpoint) is not None:
            return Notebook.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createNotebook")

    def start_notebook(self) -> Notebook:
        """starts the current user's notebook instance."""
        endpoint = "startNotebook"

        result = self.service.execute_mutation(
            endpoint=endpoint, variables={}, output=build_output_string(Notebook)
        )
        if result.get(endpoint) is not None:
            return Notebook.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation startNotebook")

    def shutdown_notebook(self) -> Notebook:
        """stops the current user's notebook instance."""
        endpoint = "shutdownNotebook"

        result = self.service.execute_mutation(
            endpoint=endpoint, variables={}, output=build_output_string(Notebook)
        )
        if result.get(endpoint) is not None:
            return Notebook.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation shutdownNotebook")

    def delete_notebook(self) -> Notebook:
        """deletes the current users notebook instance."""
        endpoint = "deleteNotebook"

        result = self.service.execute_mutation(
            endpoint=endpoint, variables={}, output=build_output_string(Notebook)
        )
        if result.get(endpoint) is not None:
            return Notebook.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteNotebook")
