"""Notifications Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum


class NotificationsOrderDirection(str, Enum):
    """NotificationsOrderDirection."""

    ASC = "asc"
    DESC = "desc"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NotificationVarsItem:
    """NotificationVarsItem."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NotificationVarsItemInput:
    """NotificationVarsItemInput."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    value: Optional[Any] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Notification:
    """Notification."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updated_at")
    )
    read_at: Optional[str] = field(default=None, metadata=config(field_name="read_at"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    message: Optional[str] = field(default=None, metadata=config(field_name="message"))
    message_html: Optional[str] = field(
        default=None, metadata=config(field_name="messageHTML")
    )
    sender: Optional[str] = field(default=None, metadata=config(field_name="sender"))
    sender_type: Optional[str] = field(
        default=None, metadata=config(field_name="sender_type")
    )
    recipient: Optional[str] = field(
        default=None, metadata=config(field_name="recipient")
    )
    recipient_type: Optional[str] = field(
        default=None, metadata=config(field_name="recipient_type")
    )
    notification_url: Optional[str] = field(
        default=None, metadata=config(field_name="notification_url")
    )
    reference_id: Optional[str] = field(
        default=None, metadata=config(field_name="reference_id")
    )
    reference_type: Optional[str] = field(
        default=None, metadata=config(field_name="reference_type")
    )
    reference_name: Optional[str] = field(
        default=None, metadata=config(field_name="reference_name")
    )
    section_id: Optional[str] = field(
        default=None, metadata=config(field_name="section_id")
    )
    section_type: Optional[str] = field(
        default=None, metadata=config(field_name="section_type")
    )
    notification_type: Optional[str] = field(
        default=None, metadata=config(field_name="notification_type")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenant_id")
    )
    user_id: Optional[str] = field(default=None, metadata=config(field_name="user_id"))
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deleted_at")
    )
    notification_vars: Optional[List[NotificationVarsItem]] = field(
        default=None, metadata=config(field_name="notification_vars")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NotificationInput:
    """NotificationInput."""

    read_at: Optional[str] = field(default=None, metadata=config(field_name="read_at"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    message: Optional[str] = field(default=None, metadata=config(field_name="message"))
    message_html: Optional[str] = field(
        default=None, metadata=config(field_name="messageHTML")
    )
    sender: Optional[str] = field(default=None, metadata=config(field_name="sender"))
    sender_type: Optional[str] = field(
        default=None, metadata=config(field_name="sender_type")
    )
    recipient: Optional[str] = field(
        default=None, metadata=config(field_name="recipient")
    )
    recipient_type: Optional[str] = field(
        default=None, metadata=config(field_name="recipient_type")
    )
    notification_url: Optional[str] = field(
        default=None, metadata=config(field_name="notification_url")
    )
    reference_id: Optional[str] = field(
        default=None, metadata=config(field_name="reference_id")
    )
    reference_type: Optional[str] = field(
        default=None, metadata=config(field_name="reference_type")
    )
    reference_name: Optional[str] = field(
        default=None, metadata=config(field_name="reference_name")
    )
    section_id: Optional[str] = field(
        default=None, metadata=config(field_name="section_id")
    )
    notification_type: Optional[str] = field(
        default=None, metadata=config(field_name="notification_type")
    )
    section_type: Optional[str] = field(
        default=None, metadata=config(field_name="section_type")
    )
    notification_vars: Optional[List[NotificationVarsItemInput]] = field(
        default=None, metadata=config(field_name="notification_vars")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NotificationTemplateInput:
    """NotificationTemplateInput."""

    read_at: Optional[str] = field(default=None, metadata=config(field_name="read_at"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    sender: Optional[str] = field(default=None, metadata=config(field_name="sender"))
    recipient: Optional[str] = field(
        default=None, metadata=config(field_name="recipient")
    )
    notification_url: Optional[str] = field(
        default=None, metadata=config(field_name="notification_url")
    )
    reference_id: Optional[str] = field(
        default=None, metadata=config(field_name="reference_id")
    )
    reference_type: Optional[str] = field(
        default=None, metadata=config(field_name="reference_type")
    )
    reference_name: Optional[str] = field(
        default=None, metadata=config(field_name="reference_name")
    )
    notification_type: Optional[str] = field(
        default=None, metadata=config(field_name="notification_type")
    )
    notification_vars: Optional[List[NotificationVarsItemInput]] = field(
        default=None, metadata=config(field_name="notification_vars")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateNotificationInput:
    """UpdateNotificationInput."""

    read_at: Optional[str] = field(default=None, metadata=config(field_name="read_at"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    message: Optional[str] = field(default=None, metadata=config(field_name="message"))
    message_html: Optional[str] = field(
        default=None, metadata=config(field_name="messageHTML")
    )
    sender: Optional[str] = field(default=None, metadata=config(field_name="sender"))
    sender_type: Optional[str] = field(
        default=None, metadata=config(field_name="sender_type")
    )
    recipient: Optional[str] = field(
        default=None, metadata=config(field_name="recipient")
    )
    recipient_type: Optional[str] = field(
        default=None, metadata=config(field_name="recipient_type")
    )
    notification_url: Optional[str] = field(
        default=None, metadata=config(field_name="notification_url")
    )
    reference_id: Optional[str] = field(
        default=None, metadata=config(field_name="reference_id")
    )
    reference_type: Optional[str] = field(
        default=None, metadata=config(field_name="reference_type")
    )
    reference_name: Optional[str] = field(
        default=None, metadata=config(field_name="reference_name")
    )
    section_id: Optional[str] = field(
        default=None, metadata=config(field_name="section_id")
    )
    notification_type: Optional[str] = field(
        default=None, metadata=config(field_name="notification_type")
    )
    section_type: Optional[str] = field(
        default=None, metadata=config(field_name="section_type")
    )
    notification_vars: Optional[List[NotificationVarsItemInput]] = field(
        default=None, metadata=config(field_name="notification_vars")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NotificationsOutput:
    """NotificationsOutput."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    notifications: Optional[List[Notification]] = field(
        default=None, metadata=config(field_name="notifications")
    )
