"""ThreatScore Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum


class EvidenceType(str, Enum):
    """EvidenceType."""

    GLOBAL_TOTAL_ALERTS = "GLOBAL_TOTAL_ALERTS"
    GLOBAL_RESOLVED_RATIO = "GLOBAL_RESOLVED_RATIO"
    GLOBAL_INVESTIGATED_RATIO = "GLOBAL_INVESTIGATED_RATIO"
    GLOBAL_TRUE_POS_MALICIOUS_RATIO = "GLOBAL_TRUE_POS_MALICIOUS_RATIO"
    TENANT_TOTAL_ALERTS = "TENANT_TOTAL_ALERTS"
    TENANT_RESOLVED_RATIO = "TENANT_RESOLVED_RATIO"
    TENANT_INVESTIGATED_RATIO = "TENANT_INVESTIGATED_RATIO"
    TENANT_TRUE_POS_MALICIOUS_RATIO = "TENANT_TRUE_POS_MALICIOUS_RATIO"
    MAX_ENTITY_RESOLVED_RATIO = "MAX_ENTITY_RESOLVED_RATIO"
    MAX_ENTITY_INVESTIGATED_RATIO = "MAX_ENTITY_INVESTIGATED_RATIO"
    MAX_ENTITY_TRUE_POS_MALICIOUS_RATIO = "MAX_ENTITY_TRUE_POS_MALICIOUS_RATIO"
    ENTITY_RESOLVED_RATIO = "ENTITY_RESOLVED_RATIO"
    ENTITY_INVESTIGATED_RATIO = "ENTITY_INVESTIGATED_RATIO"
    ENTITY_TRUE_POS_MALICIOUS_RATIO = "ENTITY_TRUE_POS_MALICIOUS_RATIO"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Entry:
    """Entry."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Evidence:
    """Evidence."""

    summary: Optional[str] = field(default=None, metadata=config(field_name="summary"))
    text: Optional[str] = field(default=None, metadata=config(field_name="text"))
    evidence_type: Optional[Union[EvidenceType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(EvidenceType, x),
            field_name="evidenceType",
        ),
    )
    parameters: Optional[List[Entry]] = field(
        default=None, metadata=config(field_name="parameters")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EntityRatio:
    """EntityRatio."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    evidence_list: Optional[List[Evidence]] = field(
        default=None, metadata=config(field_name="evidenceList")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InvestigationPredictorEvidence:
    """InvestigationPredictorEvidence."""

    tenant_scope: Optional[List[Evidence]] = field(
        default=None, metadata=config(field_name="tenantScope")
    )
    global_scope: Optional[List[Evidence]] = field(
        default=None, metadata=config(field_name="globalScope")
    )
    entity_scope: Optional[List[Evidence]] = field(
        default=None, metadata=config(field_name="entityScope")
    )
    entity_all: Optional[List[EntityRatio]] = field(
        default=None, metadata=config(field_name="entityAll")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AlertPrioritization:
    """AlertPrioritization."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    alert_created_time: Optional[str] = field(
        default=None, metadata=config(field_name="alertCreatedTime")
    )
    created_time: Optional[str] = field(
        default=None, metadata=config(field_name="createdTime")
    )
    probability: Optional[float] = field(
        default=None, metadata=config(field_name="probability")
    )
    investigation_predictor_evidence: Optional[InvestigationPredictorEvidence] = field(
        default=None, metadata=config(field_name="investigationPredictorEvidence")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Alert2:
    """Alert2."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    alert_prioritization: Optional[AlertPrioritization] = field(
        default=None, metadata=config(field_name="alertPrioritization")
    )
