# -*- coding: utf-8 -*-
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from google.cloud.discoveryengine_v1 import gapic_version as package_version

__version__ = package_version.__version__


from .services.assistant_service import (
    AssistantServiceAsyncClient,
    AssistantServiceClient,
)
from .services.cmek_config_service import (
    CmekConfigServiceAsyncClient,
    CmekConfigServiceClient,
)
from .services.completion_service import (
    CompletionServiceAsyncClient,
    CompletionServiceClient,
)
from .services.control_service import ControlServiceAsyncClient, ControlServiceClient
from .services.conversational_search_service import (
    ConversationalSearchServiceAsyncClient,
    ConversationalSearchServiceClient,
)
from .services.data_store_service import (
    DataStoreServiceAsyncClient,
    DataStoreServiceClient,
)
from .services.document_service import DocumentServiceAsyncClient, DocumentServiceClient
from .services.engine_service import EngineServiceAsyncClient, EngineServiceClient
from .services.grounded_generation_service import (
    GroundedGenerationServiceAsyncClient,
    GroundedGenerationServiceClient,
)
from .services.identity_mapping_store_service import (
    IdentityMappingStoreServiceAsyncClient,
    IdentityMappingStoreServiceClient,
)
from .services.project_service import ProjectServiceAsyncClient, ProjectServiceClient
from .services.rank_service import RankServiceAsyncClient, RankServiceClient
from .services.recommendation_service import (
    RecommendationServiceAsyncClient,
    RecommendationServiceClient,
)
from .services.schema_service import SchemaServiceAsyncClient, SchemaServiceClient
from .services.search_service import SearchServiceAsyncClient, SearchServiceClient
from .services.search_tuning_service import (
    SearchTuningServiceAsyncClient,
    SearchTuningServiceClient,
)
from .services.serving_config_service import (
    ServingConfigServiceAsyncClient,
    ServingConfigServiceClient,
)
from .services.session_service import SessionServiceAsyncClient, SessionServiceClient
from .services.site_search_engine_service import (
    SiteSearchEngineServiceAsyncClient,
    SiteSearchEngineServiceClient,
)
from .services.user_event_service import (
    UserEventServiceAsyncClient,
    UserEventServiceClient,
)
from .services.user_license_service import (
    UserLicenseServiceAsyncClient,
    UserLicenseServiceClient,
)
from .types.answer import Answer
from .types.assist_answer import (
    AssistAnswer,
    AssistantContent,
    AssistantGroundedContent,
)
from .types.assistant import Assistant
from .types.assistant_service import (
    AssistUserMetadata,
    StreamAssistRequest,
    StreamAssistResponse,
)
from .types.chunk import Chunk
from .types.cmek_config_service import (
    CmekConfig,
    DeleteCmekConfigMetadata,
    DeleteCmekConfigRequest,
    GetCmekConfigRequest,
    ListCmekConfigsRequest,
    ListCmekConfigsResponse,
    SingleRegionKey,
    UpdateCmekConfigMetadata,
    UpdateCmekConfigRequest,
)
from .types.common import (
    CustomAttribute,
    DoubleList,
    HealthcareFhirConfig,
    IndustryVertical,
    Interval,
    Principal,
    SearchAddOn,
    SearchLinkPromotion,
    SearchTier,
    SearchUseCase,
    SolutionType,
    UserInfo,
)
from .types.completion import CompletionSuggestion, SuggestionDenyListEntry
from .types.completion_service import CompleteQueryRequest, CompleteQueryResponse
from .types.control import Condition, Control
from .types.control_service import (
    CreateControlRequest,
    DeleteControlRequest,
    GetControlRequest,
    ListControlsRequest,
    ListControlsResponse,
    UpdateControlRequest,
)
from .types.conversation import (
    Conversation,
    ConversationContext,
    ConversationMessage,
    Reply,
    TextInput,
)
from .types.conversational_search_service import (
    AnswerQueryRequest,
    AnswerQueryResponse,
    ConverseConversationRequest,
    ConverseConversationResponse,
    CreateConversationRequest,
    CreateSessionRequest,
    DeleteConversationRequest,
    DeleteSessionRequest,
    GetAnswerRequest,
    GetConversationRequest,
    GetSessionRequest,
    ListConversationsRequest,
    ListConversationsResponse,
    ListSessionsRequest,
    ListSessionsResponse,
    UpdateConversationRequest,
    UpdateSessionRequest,
)
from .types.custom_tuning_model import CustomTuningModel
from .types.data_store import AdvancedSiteSearchConfig, DataStore, WorkspaceConfig
from .types.data_store_service import (
    CreateDataStoreMetadata,
    CreateDataStoreRequest,
    DeleteDataStoreMetadata,
    DeleteDataStoreRequest,
    GetDataStoreRequest,
    ListDataStoresRequest,
    ListDataStoresResponse,
    UpdateDataStoreRequest,
)
from .types.document import Document
from .types.document_processing_config import DocumentProcessingConfig
from .types.document_service import (
    BatchGetDocumentsMetadataRequest,
    BatchGetDocumentsMetadataResponse,
    CreateDocumentRequest,
    DeleteDocumentRequest,
    GetDocumentRequest,
    ListDocumentsRequest,
    ListDocumentsResponse,
    UpdateDocumentRequest,
)
from .types.engine import Engine
from .types.engine_service import (
    CreateEngineMetadata,
    CreateEngineRequest,
    DeleteEngineMetadata,
    DeleteEngineRequest,
    GetEngineRequest,
    ListEnginesRequest,
    ListEnginesResponse,
    UpdateEngineRequest,
)
from .types.grounded_generation_service import (
    CheckGroundingRequest,
    CheckGroundingResponse,
    CheckGroundingSpec,
    GenerateGroundedContentRequest,
    GenerateGroundedContentResponse,
    GroundedGenerationContent,
)
from .types.grounding import FactChunk, GroundingFact
from .types.identity_mapping_store import IdentityMappingEntry, IdentityMappingStore
from .types.identity_mapping_store_service import (
    CreateIdentityMappingStoreRequest,
    DeleteIdentityMappingStoreMetadata,
    DeleteIdentityMappingStoreRequest,
    GetIdentityMappingStoreRequest,
    IdentityMappingEntryOperationMetadata,
    ImportIdentityMappingsRequest,
    ImportIdentityMappingsResponse,
    ListIdentityMappingsRequest,
    ListIdentityMappingsResponse,
    ListIdentityMappingStoresRequest,
    ListIdentityMappingStoresResponse,
    PurgeIdentityMappingsRequest,
)
from .types.import_config import (
    AlloyDbSource,
    BigQuerySource,
    BigtableOptions,
    BigtableSource,
    CloudSqlSource,
    FhirStoreSource,
    FirestoreSource,
    GcsSource,
    ImportCompletionSuggestionsMetadata,
    ImportCompletionSuggestionsRequest,
    ImportCompletionSuggestionsResponse,
    ImportDocumentsMetadata,
    ImportDocumentsRequest,
    ImportDocumentsResponse,
    ImportErrorConfig,
    ImportSuggestionDenyListEntriesMetadata,
    ImportSuggestionDenyListEntriesRequest,
    ImportSuggestionDenyListEntriesResponse,
    ImportUserEventsMetadata,
    ImportUserEventsRequest,
    ImportUserEventsResponse,
    SpannerSource,
)
from .types.project import Project
from .types.project_service import ProvisionProjectMetadata, ProvisionProjectRequest
from .types.purge_config import (
    PurgeCompletionSuggestionsMetadata,
    PurgeCompletionSuggestionsRequest,
    PurgeCompletionSuggestionsResponse,
    PurgeDocumentsMetadata,
    PurgeDocumentsRequest,
    PurgeDocumentsResponse,
    PurgeErrorConfig,
    PurgeSuggestionDenyListEntriesMetadata,
    PurgeSuggestionDenyListEntriesRequest,
    PurgeSuggestionDenyListEntriesResponse,
    PurgeUserEventsMetadata,
    PurgeUserEventsRequest,
    PurgeUserEventsResponse,
)
from .types.rank_service import RankingRecord, RankRequest, RankResponse
from .types.recommendation_service import RecommendRequest, RecommendResponse
from .types.safety import HarmCategory, SafetyRating
from .types.schema import Schema
from .types.schema_service import (
    CreateSchemaMetadata,
    CreateSchemaRequest,
    DeleteSchemaMetadata,
    DeleteSchemaRequest,
    GetSchemaRequest,
    ListSchemasRequest,
    ListSchemasResponse,
    UpdateSchemaMetadata,
    UpdateSchemaRequest,
)
from .types.search_service import SearchRequest, SearchResponse
from .types.search_tuning_service import (
    ListCustomModelsRequest,
    ListCustomModelsResponse,
    TrainCustomModelMetadata,
    TrainCustomModelRequest,
    TrainCustomModelResponse,
)
from .types.serving_config import ServingConfig
from .types.serving_config_service import UpdateServingConfigRequest
from .types.session import Query, Session
from .types.site_search_engine import (
    Sitemap,
    SiteSearchEngine,
    SiteVerificationInfo,
    TargetSite,
)
from .types.site_search_engine_service import (
    BatchCreateTargetSiteMetadata,
    BatchCreateTargetSitesRequest,
    BatchCreateTargetSitesResponse,
    BatchVerifyTargetSitesMetadata,
    BatchVerifyTargetSitesRequest,
    BatchVerifyTargetSitesResponse,
    CreateSitemapMetadata,
    CreateSitemapRequest,
    CreateTargetSiteMetadata,
    CreateTargetSiteRequest,
    DeleteSitemapMetadata,
    DeleteSitemapRequest,
    DeleteTargetSiteMetadata,
    DeleteTargetSiteRequest,
    DisableAdvancedSiteSearchMetadata,
    DisableAdvancedSiteSearchRequest,
    DisableAdvancedSiteSearchResponse,
    EnableAdvancedSiteSearchMetadata,
    EnableAdvancedSiteSearchRequest,
    EnableAdvancedSiteSearchResponse,
    FetchDomainVerificationStatusRequest,
    FetchDomainVerificationStatusResponse,
    FetchSitemapsRequest,
    FetchSitemapsResponse,
    GetSiteSearchEngineRequest,
    GetTargetSiteRequest,
    ListTargetSitesRequest,
    ListTargetSitesResponse,
    RecrawlUrisMetadata,
    RecrawlUrisRequest,
    RecrawlUrisResponse,
    UpdateTargetSiteMetadata,
    UpdateTargetSiteRequest,
)
from .types.user_event import (
    CompletionInfo,
    DocumentInfo,
    MediaInfo,
    PageInfo,
    PanelInfo,
    SearchInfo,
    TransactionInfo,
    UserEvent,
)
from .types.user_event_service import CollectUserEventRequest, WriteUserEventRequest
from .types.user_license import UserLicense
from .types.user_license_service import (
    BatchUpdateUserLicensesMetadata,
    BatchUpdateUserLicensesRequest,
    BatchUpdateUserLicensesResponse,
    ListUserLicensesRequest,
    ListUserLicensesResponse,
)

__all__ = (
    "AssistantServiceAsyncClient",
    "CmekConfigServiceAsyncClient",
    "CompletionServiceAsyncClient",
    "ControlServiceAsyncClient",
    "ConversationalSearchServiceAsyncClient",
    "DataStoreServiceAsyncClient",
    "DocumentServiceAsyncClient",
    "EngineServiceAsyncClient",
    "GroundedGenerationServiceAsyncClient",
    "IdentityMappingStoreServiceAsyncClient",
    "ProjectServiceAsyncClient",
    "RankServiceAsyncClient",
    "RecommendationServiceAsyncClient",
    "SchemaServiceAsyncClient",
    "SearchServiceAsyncClient",
    "SearchTuningServiceAsyncClient",
    "ServingConfigServiceAsyncClient",
    "SessionServiceAsyncClient",
    "SiteSearchEngineServiceAsyncClient",
    "UserEventServiceAsyncClient",
    "UserLicenseServiceAsyncClient",
    "AdvancedSiteSearchConfig",
    "AlloyDbSource",
    "Answer",
    "AnswerQueryRequest",
    "AnswerQueryResponse",
    "AssistAnswer",
    "AssistUserMetadata",
    "Assistant",
    "AssistantContent",
    "AssistantGroundedContent",
    "AssistantServiceClient",
    "BatchCreateTargetSiteMetadata",
    "BatchCreateTargetSitesRequest",
    "BatchCreateTargetSitesResponse",
    "BatchGetDocumentsMetadataRequest",
    "BatchGetDocumentsMetadataResponse",
    "BatchUpdateUserLicensesMetadata",
    "BatchUpdateUserLicensesRequest",
    "BatchUpdateUserLicensesResponse",
    "BatchVerifyTargetSitesMetadata",
    "BatchVerifyTargetSitesRequest",
    "BatchVerifyTargetSitesResponse",
    "BigQuerySource",
    "BigtableOptions",
    "BigtableSource",
    "CheckGroundingRequest",
    "CheckGroundingResponse",
    "CheckGroundingSpec",
    "Chunk",
    "CloudSqlSource",
    "CmekConfig",
    "CmekConfigServiceClient",
    "CollectUserEventRequest",
    "CompleteQueryRequest",
    "CompleteQueryResponse",
    "CompletionInfo",
    "CompletionServiceClient",
    "CompletionSuggestion",
    "Condition",
    "Control",
    "ControlServiceClient",
    "Conversation",
    "ConversationContext",
    "ConversationMessage",
    "ConversationalSearchServiceClient",
    "ConverseConversationRequest",
    "ConverseConversationResponse",
    "CreateControlRequest",
    "CreateConversationRequest",
    "CreateDataStoreMetadata",
    "CreateDataStoreRequest",
    "CreateDocumentRequest",
    "CreateEngineMetadata",
    "CreateEngineRequest",
    "CreateIdentityMappingStoreRequest",
    "CreateSchemaMetadata",
    "CreateSchemaRequest",
    "CreateSessionRequest",
    "CreateSitemapMetadata",
    "CreateSitemapRequest",
    "CreateTargetSiteMetadata",
    "CreateTargetSiteRequest",
    "CustomAttribute",
    "CustomTuningModel",
    "DataStore",
    "DataStoreServiceClient",
    "DeleteCmekConfigMetadata",
    "DeleteCmekConfigRequest",
    "DeleteControlRequest",
    "DeleteConversationRequest",
    "DeleteDataStoreMetadata",
    "DeleteDataStoreRequest",
    "DeleteDocumentRequest",
    "DeleteEngineMetadata",
    "DeleteEngineRequest",
    "DeleteIdentityMappingStoreMetadata",
    "DeleteIdentityMappingStoreRequest",
    "DeleteSchemaMetadata",
    "DeleteSchemaRequest",
    "DeleteSessionRequest",
    "DeleteSitemapMetadata",
    "DeleteSitemapRequest",
    "DeleteTargetSiteMetadata",
    "DeleteTargetSiteRequest",
    "DisableAdvancedSiteSearchMetadata",
    "DisableAdvancedSiteSearchRequest",
    "DisableAdvancedSiteSearchResponse",
    "Document",
    "DocumentInfo",
    "DocumentProcessingConfig",
    "DocumentServiceClient",
    "DoubleList",
    "EnableAdvancedSiteSearchMetadata",
    "EnableAdvancedSiteSearchRequest",
    "EnableAdvancedSiteSearchResponse",
    "Engine",
    "EngineServiceClient",
    "FactChunk",
    "FetchDomainVerificationStatusRequest",
    "FetchDomainVerificationStatusResponse",
    "FetchSitemapsRequest",
    "FetchSitemapsResponse",
    "FhirStoreSource",
    "FirestoreSource",
    "GcsSource",
    "GenerateGroundedContentRequest",
    "GenerateGroundedContentResponse",
    "GetAnswerRequest",
    "GetCmekConfigRequest",
    "GetControlRequest",
    "GetConversationRequest",
    "GetDataStoreRequest",
    "GetDocumentRequest",
    "GetEngineRequest",
    "GetIdentityMappingStoreRequest",
    "GetSchemaRequest",
    "GetSessionRequest",
    "GetSiteSearchEngineRequest",
    "GetTargetSiteRequest",
    "GroundedGenerationContent",
    "GroundedGenerationServiceClient",
    "GroundingFact",
    "HarmCategory",
    "HealthcareFhirConfig",
    "IdentityMappingEntry",
    "IdentityMappingEntryOperationMetadata",
    "IdentityMappingStore",
    "IdentityMappingStoreServiceClient",
    "ImportCompletionSuggestionsMetadata",
    "ImportCompletionSuggestionsRequest",
    "ImportCompletionSuggestionsResponse",
    "ImportDocumentsMetadata",
    "ImportDocumentsRequest",
    "ImportDocumentsResponse",
    "ImportErrorConfig",
    "ImportIdentityMappingsRequest",
    "ImportIdentityMappingsResponse",
    "ImportSuggestionDenyListEntriesMetadata",
    "ImportSuggestionDenyListEntriesRequest",
    "ImportSuggestionDenyListEntriesResponse",
    "ImportUserEventsMetadata",
    "ImportUserEventsRequest",
    "ImportUserEventsResponse",
    "IndustryVertical",
    "Interval",
    "ListCmekConfigsRequest",
    "ListCmekConfigsResponse",
    "ListControlsRequest",
    "ListControlsResponse",
    "ListConversationsRequest",
    "ListConversationsResponse",
    "ListCustomModelsRequest",
    "ListCustomModelsResponse",
    "ListDataStoresRequest",
    "ListDataStoresResponse",
    "ListDocumentsRequest",
    "ListDocumentsResponse",
    "ListEnginesRequest",
    "ListEnginesResponse",
    "ListIdentityMappingStoresRequest",
    "ListIdentityMappingStoresResponse",
    "ListIdentityMappingsRequest",
    "ListIdentityMappingsResponse",
    "ListSchemasRequest",
    "ListSchemasResponse",
    "ListSessionsRequest",
    "ListSessionsResponse",
    "ListTargetSitesRequest",
    "ListTargetSitesResponse",
    "ListUserLicensesRequest",
    "ListUserLicensesResponse",
    "MediaInfo",
    "PageInfo",
    "PanelInfo",
    "Principal",
    "Project",
    "ProjectServiceClient",
    "ProvisionProjectMetadata",
    "ProvisionProjectRequest",
    "PurgeCompletionSuggestionsMetadata",
    "PurgeCompletionSuggestionsRequest",
    "PurgeCompletionSuggestionsResponse",
    "PurgeDocumentsMetadata",
    "PurgeDocumentsRequest",
    "PurgeDocumentsResponse",
    "PurgeErrorConfig",
    "PurgeIdentityMappingsRequest",
    "PurgeSuggestionDenyListEntriesMetadata",
    "PurgeSuggestionDenyListEntriesRequest",
    "PurgeSuggestionDenyListEntriesResponse",
    "PurgeUserEventsMetadata",
    "PurgeUserEventsRequest",
    "PurgeUserEventsResponse",
    "Query",
    "RankRequest",
    "RankResponse",
    "RankServiceClient",
    "RankingRecord",
    "RecommendRequest",
    "RecommendResponse",
    "RecommendationServiceClient",
    "RecrawlUrisMetadata",
    "RecrawlUrisRequest",
    "RecrawlUrisResponse",
    "Reply",
    "SafetyRating",
    "Schema",
    "SchemaServiceClient",
    "SearchAddOn",
    "SearchInfo",
    "SearchLinkPromotion",
    "SearchRequest",
    "SearchResponse",
    "SearchServiceClient",
    "SearchTier",
    "SearchTuningServiceClient",
    "SearchUseCase",
    "ServingConfig",
    "ServingConfigServiceClient",
    "Session",
    "SessionServiceClient",
    "SingleRegionKey",
    "SiteSearchEngine",
    "SiteSearchEngineServiceClient",
    "SiteVerificationInfo",
    "Sitemap",
    "SolutionType",
    "SpannerSource",
    "StreamAssistRequest",
    "StreamAssistResponse",
    "SuggestionDenyListEntry",
    "TargetSite",
    "TextInput",
    "TrainCustomModelMetadata",
    "TrainCustomModelRequest",
    "TrainCustomModelResponse",
    "TransactionInfo",
    "UpdateCmekConfigMetadata",
    "UpdateCmekConfigRequest",
    "UpdateControlRequest",
    "UpdateConversationRequest",
    "UpdateDataStoreRequest",
    "UpdateDocumentRequest",
    "UpdateEngineRequest",
    "UpdateSchemaMetadata",
    "UpdateSchemaRequest",
    "UpdateServingConfigRequest",
    "UpdateSessionRequest",
    "UpdateTargetSiteMetadata",
    "UpdateTargetSiteRequest",
    "UserEvent",
    "UserEventServiceClient",
    "UserInfo",
    "UserLicense",
    "UserLicenseServiceClient",
    "WorkspaceConfig",
    "WriteUserEventRequest",
)
