
# Getting Started with Aviationstack

## Introduction

### Quick Start Guide

#### Step 1: Your API Access Key

To get started quickly, you need to fork the Aviationstack Postman Collection. Simply click the button below to fork it.

[<img src="https://run.pstmn.io/button.svg">](https://god.gw.postman.com/run-collection/10131015-72ee0d35-018e-4370-a2b6-a66d3ebd5b5a?action=collection/fork)

##### Step 2: Get your API Access Key

1. Go to the [Aviationstack](https://aviationstack.com/) website and choose the right subscription plan for your particular project.
2. Get your personal API Access Key on the [Dashboard](https://aviationstack.com/dashboard) to authenticate with the API. Keep it safe! You can reset it at any time in your Account Dashboard.

#### Step 3: Make your first API call

Aviationstack Postman collection contains all the endpoints supported by Aviationstack API.

1. Flights
2. Routes
3. Airports
4. Airlines
5. Airplanes
6. Aircraft Types
7. Taxes
8. Cities
9. Countries
10. Flights Schedules
11. Flights Future Schedules

## Install the Package

The package is compatible with Python versions `3.7+`.
Install the package from PyPi using the following pip command:

```bash
pip install aviation-stack-sdk==1.0.0
```

You can also view the package at:
https://pypi.python.org/pypi/aviation-stack-sdk/1.0.0

## Test the SDK

You can test the generated SDK and the server with test cases. `unittest` is used as the testing framework and `pytest` is used as the test runner. You can run the tests as follows:

Navigate to the root directory of the SDK and run the following commands

```
pip install -r test-requirements.txt
pytest
```

## Initialize the API Client

**_Note:_** Documentation for the client can be found [here.](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/client.md)

The following parameters are configurable for the API Client:

| Parameter | Type | Description |
|  --- | --- | --- |
| environment | `Environment` | The API environment. <br> **Default: `Environment.PRODUCTION`** |
| http_client_instance | `HttpClient` | The Http Client passed from the sdk user for making requests |
| override_http_client_configuration | `bool` | The value which determines to override properties of the passed Http Client from the sdk user |
| http_call_back | `HttpCallBack` | The callback value that is invoked before and after an HTTP call is made to an endpoint |
| timeout | `float` | The value to use for connection timeout. <br> **Default: 60** |
| max_retries | `int` | The number of times to retry an endpoint call if it fails. <br> **Default: 0** |
| backoff_factor | `float` | A backoff factor to apply between attempts after the second try. <br> **Default: 2** |
| retry_statuses | `Array of int` | The http statuses on which retry is to be done. <br> **Default: [408, 413, 429, 500, 502, 503, 504, 521, 522, 524]** |
| retry_methods | `Array of string` | The http methods on which retry is to be done. <br> **Default: ['GET', 'PUT']** |
| custom_query_authentication_credentials | [`CustomQueryAuthenticationCredentials`](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/auth/custom-query-parameter.md) | The credential object for Custom Query Parameter |

The API client can be initialized as follows:

```python
from aviationstack.aviationstack_client import AviationstackClient
from aviationstack.configuration import Environment
from aviationstack.http.auth.custom_query_authentication import CustomQueryAuthenticationCredentials

client = AviationstackClient(
    custom_query_authentication_credentials=CustomQueryAuthenticationCredentials(
        access_key='access_key'
    ),
    environment=Environment.PRODUCTION
)
```

## Authorization

This API uses the following authentication schemes.

* [`apiKey (Custom Query Parameter)`](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/auth/custom-query-parameter.md)

## List of APIs

* [Aircraft Types](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/controllers/aircraft-types.md)
* [Flight Schedules](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/controllers/flight-schedules.md)
* [Flight Future Schedules](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/controllers/flight-future-schedules.md)
* [Flights](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/controllers/flights.md)
* [Routes](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/controllers/routes.md)
* [Airports](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/controllers/airports.md)
* [Airlines](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/controllers/airlines.md)
* [Airplanes](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/controllers/airplanes.md)
* [Taxes](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/controllers/taxes.md)
* [Cities](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/controllers/cities.md)
* [Countries](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/controllers/countries.md)

## SDK Infrastructure

### HTTP

* [HttpResponse](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/http-response.md)
* [HttpRequest](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/http-request.md)

### Utilities

* [ApiHelper](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/api-helper.md)
* [HttpDateTime](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/http-date-time.md)
* [RFC3339DateTime](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/rfc3339-date-time.md)
* [UnixDateTime](https://www.github.com/MuHamza30/aviation-stack-python-sdk/tree/1.0.0/doc/unix-date-time.md)

