# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from aviationstack.api_helper import APIHelper
from aviationstack.configuration import Server
from aviationstack.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from aviationstack.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from aviationstack.models.m_200_ok_flight_future_schedules import M200OKFlightFutureSchedules


class FlightFutureSchedulesController(BaseController):

    """A Controller to access Endpoints in the aviationstack API."""
    def __init__(self, config):
        super(FlightFutureSchedulesController, self).__init__(config)

    def flight_future_schedules(self,
                                iata_code,
                                mtype,
                                date):
        """Does a GET request to /flightsFuture.

        Args:
            iata_code (str): [Required] The IATA code of the airport you'd
                like to request data from. Example: JFK,DXB.
            mtype (str): [Required] Airport schedule type. Available values:
                departure or arrival.
            date (str): [Required] Filter your results by providing a flight
                date in the format YYYY-MM-DD.

        Returns:
            M200OKFlightFutureSchedules: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER_1)
            .path('/flightsFuture')
            .http_method(HttpMethodEnum.GET)
            .query_param(Parameter()
                         .key('iataCode')
                         .value(iata_code))
            .query_param(Parameter()
                         .key('type')
                         .value(mtype))
            .query_param(Parameter()
                         .key('date')
                         .value(date))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('apiKey'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(M200OKFlightFutureSchedules.from_dictionary)
        ).execute()
