# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from aviationstack.api_helper import APIHelper
from aviationstack.configuration import Server
from aviationstack.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from aviationstack.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from aviationstack.models.m_200_ok_ream_time import M200OKReamTime
from aviationstack.models.m_200_ok_historical import M200OKHistorical


class FlightsController(BaseController):

    """A Controller to access Endpoints in the aviationstack API."""
    def __init__(self, config):
        super(FlightsController, self).__init__(config)

    def real_time(self):
        """Does a GET request to /flights.

        The Flight endpoint is capable of tracking flights and retrieving
        flight status information in real-time.

        Returns:
            M200OKReamTime: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER_1)
            .path('/flights')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('apiKey'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(M200OKReamTime.from_dictionary)
        ).execute()

    def historical(self,
                   flight_date):
        """Does a GET request to /flights.

        Args:
            flight_date (str): The request query parameter.

        Returns:
            M200OKHistorical: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVER_1)
            .path('/flights')
            .http_method(HttpMethodEnum.GET)
            .query_param(Parameter()
                         .key('flight_date')
                         .value(flight_date))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('apiKey'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(M200OKHistorical.from_dictionary)
        ).execute()
