# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Aircraft(object):

    """Implementation of the 'Aircraft' model.

    Attributes:
        registration (str): The model property of type str.
        iata (str): The model property of type str.
        icao (str): The model property of type str.
        icao_24 (str): The model property of type str.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "registration": 'registration',
        "iata": 'iata',
        "icao": 'icao',
        "icao_24": 'icao24'
    }

    _optionals = [
        'registration',
        'iata',
        'icao',
        'icao_24',
    ]

    def __init__(self,
                 registration=APIHelper.SKIP,
                 iata=APIHelper.SKIP,
                 icao=APIHelper.SKIP,
                 icao_24=APIHelper.SKIP):
        """Constructor for the Aircraft class"""

        # Initialize members of the class
        if registration is not APIHelper.SKIP:
            self.registration = registration 
        if iata is not APIHelper.SKIP:
            self.iata = iata 
        if icao is not APIHelper.SKIP:
            self.icao = icao 
        if icao_24 is not APIHelper.SKIP:
            self.icao_24 = icao_24 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        registration = dictionary.get("registration") if dictionary.get("registration") else APIHelper.SKIP
        iata = dictionary.get("iata") if dictionary.get("iata") else APIHelper.SKIP
        icao = dictionary.get("icao") if dictionary.get("icao") else APIHelper.SKIP
        icao_24 = dictionary.get("icao24") if dictionary.get("icao24") else APIHelper.SKIP
        # Return an object of this model
        return cls(registration,
                   iata,
                   icao,
                   icao_24)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'registration={(self.registration if hasattr(self, "registration") else None)!r}, '
                f'iata={(self.iata if hasattr(self, "iata") else None)!r}, '
                f'icao={(self.icao if hasattr(self, "icao") else None)!r}, '
                f'icao_24={(self.icao_24 if hasattr(self, "icao_24") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'registration={(self.registration if hasattr(self, "registration") else None)!s}, '
                f'iata={(self.iata if hasattr(self, "iata") else None)!s}, '
                f'icao={(self.icao if hasattr(self, "icao") else None)!s}, '
                f'icao_24={(self.icao_24 if hasattr(self, "icao_24") else None)!s})')
