# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Aircraft1(object):

    """Implementation of the 'Aircraft1' model.

    Attributes:
        registration (str): The model property of type str.
        iata (str): The model property of type str.
        icao (str): The model property of type str.
        icao_24 (str): The model property of type str.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "registration": 'registration',
        "iata": 'iata',
        "icao": 'icao',
        "icao_24": 'icao24'
    }

    def __init__(self,
                 registration=None,
                 iata=None,
                 icao=None,
                 icao_24=None):
        """Constructor for the Aircraft1 class"""

        # Initialize members of the class
        self.registration = registration 
        self.iata = iata 
        self.icao = icao 
        self.icao_24 = icao_24 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        registration = dictionary.get("registration") if dictionary.get("registration") else None
        iata = dictionary.get("iata") if dictionary.get("iata") else None
        icao = dictionary.get("icao") if dictionary.get("icao") else None
        icao_24 = dictionary.get("icao24") if dictionary.get("icao24") else None
        # Return an object of this model
        return cls(registration,
                   iata,
                   icao,
                   icao_24)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return APIHelper.is_valid_type(value=dictionary.registration,
                                           type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.iata,
                                            type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.icao,
                                            type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.icao_24,
                                            type_callable=lambda value: isinstance(value, str))

        if not isinstance(dictionary, dict):
            return False

        return APIHelper.is_valid_type(value=dictionary.get('registration'),
                                       type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('iata'),
                                        type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('icao'),
                                        type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('icao24'),
                                        type_callable=lambda value: isinstance(value, str))

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'registration={self.registration!r}, '
                f'iata={self.iata!r}, '
                f'icao={self.icao!r}, '
                f'icao_24={self.icao_24!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'registration={self.registration!s}, '
                f'iata={self.iata!s}, '
                f'icao={self.icao!s}, '
                f'icao_24={self.icao_24!s})')
