# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Airline6(object):

    """Implementation of the 'Airline6' model.

    Attributes:
        iata_code (str): The model property of type str.
        icao_code (str): The model property of type str.
        name (str): The model property of type str.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "iata_code": 'iataCode',
        "icao_code": 'icaoCode',
        "name": 'name'
    }

    def __init__(self,
                 iata_code=None,
                 icao_code=None,
                 name=None):
        """Constructor for the Airline6 class"""

        # Initialize members of the class
        self.iata_code = iata_code 
        self.icao_code = icao_code 
        self.name = name 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        iata_code = dictionary.get("iataCode") if dictionary.get("iataCode") else None
        icao_code = dictionary.get("icaoCode") if dictionary.get("icaoCode") else None
        name = dictionary.get("name") if dictionary.get("name") else None
        # Return an object of this model
        return cls(iata_code,
                   icao_code,
                   name)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return APIHelper.is_valid_type(value=dictionary.iata_code,
                                           type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.icao_code,
                                            type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.name,
                                            type_callable=lambda value: isinstance(value, str))

        if not isinstance(dictionary, dict):
            return False

        return APIHelper.is_valid_type(value=dictionary.get('iataCode'),
                                       type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('icaoCode'),
                                        type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('name'),
                                        type_callable=lambda value: isinstance(value, str))

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'iata_code={self.iata_code!r}, '
                f'icao_code={self.icao_code!r}, '
                f'name={self.name!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'iata_code={self.iata_code!s}, '
                f'icao_code={self.icao_code!s}, '
                f'name={self.name!s})')
