# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Codeshared(object):

    """Implementation of the 'Codeshared' model.

    Attributes:
        airline_name (str): The model property of type str.
        airline_iata (str): The model property of type str.
        airline_icao (str): The model property of type str.
        flight_number (str): The model property of type str.
        flight_iata (str): The model property of type str.
        flight_icao (str): The model property of type str.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "airline_name": 'airline_name',
        "airline_iata": 'airline_iata',
        "airline_icao": 'airline_icao',
        "flight_number": 'flight_number',
        "flight_iata": 'flight_iata',
        "flight_icao": 'flight_icao'
    }

    _optionals = [
        'airline_name',
        'airline_iata',
        'airline_icao',
        'flight_number',
        'flight_iata',
        'flight_icao',
    ]

    def __init__(self,
                 airline_name=APIHelper.SKIP,
                 airline_iata=APIHelper.SKIP,
                 airline_icao=APIHelper.SKIP,
                 flight_number=APIHelper.SKIP,
                 flight_iata=APIHelper.SKIP,
                 flight_icao=APIHelper.SKIP):
        """Constructor for the Codeshared class"""

        # Initialize members of the class
        if airline_name is not APIHelper.SKIP:
            self.airline_name = airline_name 
        if airline_iata is not APIHelper.SKIP:
            self.airline_iata = airline_iata 
        if airline_icao is not APIHelper.SKIP:
            self.airline_icao = airline_icao 
        if flight_number is not APIHelper.SKIP:
            self.flight_number = flight_number 
        if flight_iata is not APIHelper.SKIP:
            self.flight_iata = flight_iata 
        if flight_icao is not APIHelper.SKIP:
            self.flight_icao = flight_icao 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        airline_name = dictionary.get("airline_name") if dictionary.get("airline_name") else APIHelper.SKIP
        airline_iata = dictionary.get("airline_iata") if dictionary.get("airline_iata") else APIHelper.SKIP
        airline_icao = dictionary.get("airline_icao") if dictionary.get("airline_icao") else APIHelper.SKIP
        flight_number = dictionary.get("flight_number") if dictionary.get("flight_number") else APIHelper.SKIP
        flight_iata = dictionary.get("flight_iata") if dictionary.get("flight_iata") else APIHelper.SKIP
        flight_icao = dictionary.get("flight_icao") if dictionary.get("flight_icao") else APIHelper.SKIP
        # Return an object of this model
        return cls(airline_name,
                   airline_iata,
                   airline_icao,
                   flight_number,
                   flight_iata,
                   flight_icao)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'airline_name={(self.airline_name if hasattr(self, "airline_name") else None)!r}, '
                f'airline_iata={(self.airline_iata if hasattr(self, "airline_iata") else None)!r}, '
                f'airline_icao={(self.airline_icao if hasattr(self, "airline_icao") else None)!r}, '
                f'flight_number={(self.flight_number if hasattr(self, "flight_number") else None)!r}, '
                f'flight_iata={(self.flight_iata if hasattr(self, "flight_iata") else None)!r}, '
                f'flight_icao={(self.flight_icao if hasattr(self, "flight_icao") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'airline_name={(self.airline_name if hasattr(self, "airline_name") else None)!s}, '
                f'airline_iata={(self.airline_iata if hasattr(self, "airline_iata") else None)!s}, '
                f'airline_icao={(self.airline_icao if hasattr(self, "airline_icao") else None)!s}, '
                f'flight_number={(self.flight_number if hasattr(self, "flight_number") else None)!s}, '
                f'flight_iata={(self.flight_iata if hasattr(self, "flight_iata") else None)!s}, '
                f'flight_icao={(self.flight_icao if hasattr(self, "flight_icao") else None)!s})')
