# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper
from aviationstack.models.airline_6 import Airline6
from aviationstack.models.flight_6 import Flight6


class Codeshared6(object):

    """Implementation of the 'Codeshared6' model.

    Attributes:
        airline (Airline6): The model property of type Airline6.
        flight (Flight6): The model property of type Flight6.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "airline": 'airline',
        "flight": 'flight'
    }

    _optionals = [
        'airline',
        'flight',
    ]

    def __init__(self,
                 airline=APIHelper.SKIP,
                 flight=APIHelper.SKIP):
        """Constructor for the Codeshared6 class"""

        # Initialize members of the class
        if airline is not APIHelper.SKIP:
            self.airline = airline 
        if flight is not APIHelper.SKIP:
            self.flight = flight 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        airline = Airline6.from_dictionary(dictionary.get('airline')) if 'airline' in dictionary.keys() else APIHelper.SKIP
        flight = Flight6.from_dictionary(dictionary.get('flight')) if 'flight' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(airline,
                   flight)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'airline={(self.airline if hasattr(self, "airline") else None)!r}, '
                f'flight={(self.flight if hasattr(self, "flight") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'airline={(self.airline if hasattr(self, "airline") else None)!s}, '
                f'flight={(self.flight if hasattr(self, "flight") else None)!s})')
