# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper
from aviationstack.models.airline_6 import Airline6
from aviationstack.models.flight_6 import Flight6


class Codeshared61(object):

    """Implementation of the 'Codeshared61' model.

    Attributes:
        airline (Airline6): The model property of type Airline6.
        flight (Flight6): The model property of type Flight6.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "airline": 'airline',
        "flight": 'flight'
    }

    def __init__(self,
                 airline=None,
                 flight=None):
        """Constructor for the Codeshared61 class"""

        # Initialize members of the class
        self.airline = airline 
        self.flight = flight 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        airline = Airline6.from_dictionary(dictionary.get('airline')) if dictionary.get('airline') else None
        flight = Flight6.from_dictionary(dictionary.get('flight')) if dictionary.get('flight') else None
        # Return an object of this model
        return cls(airline,
                   flight)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return APIHelper.is_valid_type(value=dictionary.airline,
                                           type_callable=lambda value: Airline6.validate(value),
                                           is_model_dict=True) \
                and APIHelper.is_valid_type(value=dictionary.flight,
                                            type_callable=lambda value: Flight6.validate(value),
                                            is_model_dict=True)

        if not isinstance(dictionary, dict):
            return False

        return APIHelper.is_valid_type(value=dictionary.get('airline'),
                                       type_callable=lambda value: Airline6.validate(value),
                                       is_model_dict=True) \
            and APIHelper.is_valid_type(value=dictionary.get('flight'),
                                        type_callable=lambda value: Flight6.validate(value),
                                        is_model_dict=True)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'airline={self.airline!r}, '
                f'flight={self.flight!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'airline={self.airline!s}, '
                f'flight={self.flight!s})')
