# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.models.airline import Airline
from aviationstack.models.arrival import Arrival
from aviationstack.models.departure import Departure
from aviationstack.models.flight import Flight


class Datum(object):

    """Implementation of the 'Datum' model.

    Attributes:
        flight_date (str): The model property of type str.
        flight_status (str): The model property of type str.
        departure (Departure): The model property of type Departure.
        arrival (Arrival): The model property of type Arrival.
        airline (Airline): The model property of type Airline.
        flight (Flight): The model property of type Flight.
        aircraft (str): The model property of type str.
        live (str): The model property of type str.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "flight_date": 'flight_date',
        "flight_status": 'flight_status',
        "departure": 'departure',
        "arrival": 'arrival',
        "airline": 'airline',
        "flight": 'flight',
        "aircraft": 'aircraft',
        "live": 'live'
    }

    _nullables = [
        'aircraft',
        'live',
    ]

    def __init__(self,
                 flight_date=None,
                 flight_status=None,
                 departure=None,
                 arrival=None,
                 airline=None,
                 flight=None,
                 aircraft=None,
                 live=None):
        """Constructor for the Datum class"""

        # Initialize members of the class
        self.flight_date = flight_date 
        self.flight_status = flight_status 
        self.departure = departure 
        self.arrival = arrival 
        self.airline = airline 
        self.flight = flight 
        self.aircraft = aircraft 
        self.live = live 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        flight_date = dictionary.get("flight_date") if dictionary.get("flight_date") else None
        flight_status = dictionary.get("flight_status") if dictionary.get("flight_status") else None
        departure = Departure.from_dictionary(dictionary.get('departure')) if dictionary.get('departure') else None
        arrival = Arrival.from_dictionary(dictionary.get('arrival')) if dictionary.get('arrival') else None
        airline = Airline.from_dictionary(dictionary.get('airline')) if dictionary.get('airline') else None
        flight = Flight.from_dictionary(dictionary.get('flight')) if dictionary.get('flight') else None
        aircraft = dictionary.get("aircraft") if dictionary.get("aircraft") else None
        live = dictionary.get("live") if dictionary.get("live") else None
        # Return an object of this model
        return cls(flight_date,
                   flight_status,
                   departure,
                   arrival,
                   airline,
                   flight,
                   aircraft,
                   live)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'flight_date={self.flight_date!r}, '
                f'flight_status={self.flight_status!r}, '
                f'departure={self.departure!r}, '
                f'arrival={self.arrival!r}, '
                f'airline={self.airline!r}, '
                f'flight={self.flight!r}, '
                f'aircraft={self.aircraft!r}, '
                f'live={self.live!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'flight_date={self.flight_date!s}, '
                f'flight_status={self.flight_status!s}, '
                f'departure={self.departure!s}, '
                f'arrival={self.arrival!s}, '
                f'airline={self.airline!s}, '
                f'flight={self.flight!s}, '
                f'aircraft={self.aircraft!s}, '
                f'live={self.live!s})')
