# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper
from aviationstack.models.airline_2 import Airline2
from aviationstack.models.arrival_2 import Arrival2
from aviationstack.models.departure_2 import Departure2
from aviationstack.models.flight_2 import Flight2


class Datum2(object):

    """Implementation of the 'Datum2' model.

    Attributes:
        flight_date (str): The model property of type str.
        flight_status (str): The model property of type str.
        departure (Departure2): The model property of type Departure2.
        arrival (Arrival2): The model property of type Arrival2.
        airline (Airline2): The model property of type Airline2.
        flight (Flight2): The model property of type Flight2.
        aircraft (Aircraft | None | Aircraft1): The model property of type
            Aircraft | None | Aircraft1.
        live (str): The model property of type str.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "flight_date": 'flight_date',
        "flight_status": 'flight_status',
        "departure": 'departure',
        "arrival": 'arrival',
        "airline": 'airline',
        "flight": 'flight',
        "aircraft": 'aircraft',
        "live": 'live'
    }

    _nullables = [
        'flight_status',
        'aircraft',
        'live',
    ]

    def __init__(self,
                 flight_date=None,
                 flight_status=None,
                 departure=None,
                 arrival=None,
                 airline=None,
                 flight=None,
                 aircraft=None,
                 live=None):
        """Constructor for the Datum2 class"""

        # Initialize members of the class
        self.flight_date = flight_date 
        self.flight_status = flight_status 
        self.departure = departure 
        self.arrival = arrival 
        self.airline = airline 
        self.flight = flight 
        self.aircraft = aircraft 
        self.live = live 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        from aviationstack.utilities.union_type_lookup import UnionTypeLookUp

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        flight_date = dictionary.get("flight_date") if dictionary.get("flight_date") else None
        flight_status = dictionary.get("flight_status") if dictionary.get("flight_status") else None
        departure = Departure2.from_dictionary(dictionary.get('departure')) if dictionary.get('departure') else None
        arrival = Arrival2.from_dictionary(dictionary.get('arrival')) if dictionary.get('arrival') else None
        airline = Airline2.from_dictionary(dictionary.get('airline')) if dictionary.get('airline') else None
        flight = Flight2.from_dictionary(dictionary.get('flight')) if dictionary.get('flight') else None
        aircraft = APIHelper.deserialize_union_type(UnionTypeLookUp.get('Datum2Aircraft'), dictionary.get('aircraft'), False) if dictionary.get('aircraft') is not None else None
        live = dictionary.get("live") if dictionary.get("live") else None
        # Return an object of this model
        return cls(flight_date,
                   flight_status,
                   departure,
                   arrival,
                   airline,
                   flight,
                   aircraft,
                   live)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """
        from aviationstack.utilities.union_type_lookup import UnionTypeLookUp

        if isinstance(dictionary, cls):
            return APIHelper.is_valid_type(value=dictionary.flight_date,
                                           type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.flight_status,
                                            type_callable=lambda value: isinstance(value, str),
                                            is_value_nullable=True) \
                and APIHelper.is_valid_type(value=dictionary.departure,
                                            type_callable=lambda value: Departure2.validate(value),
                                            is_model_dict=True) \
                and APIHelper.is_valid_type(value=dictionary.arrival,
                                            type_callable=lambda value: Arrival2.validate(value),
                                            is_model_dict=True) \
                and APIHelper.is_valid_type(value=dictionary.airline,
                                            type_callable=lambda value: Airline2.validate(value),
                                            is_model_dict=True) \
                and APIHelper.is_valid_type(value=dictionary.flight,
                                            type_callable=lambda value: Flight2.validate(value),
                                            is_model_dict=True) \
                and UnionTypeLookUp.get('Datum2Aircraft').validate(dictionary.aircraft).is_valid \
                and APIHelper.is_valid_type(value=dictionary.live,
                                            type_callable=lambda value: isinstance(value, str),
                                            is_value_nullable=True)

        if not isinstance(dictionary, dict):
            return False

        return APIHelper.is_valid_type(value=dictionary.get('flight_date'),
                                       type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('flight_status'),
                                        type_callable=lambda value: isinstance(value, str),
                                        is_value_nullable=True) \
            and APIHelper.is_valid_type(value=dictionary.get('departure'),
                                        type_callable=lambda value: Departure2.validate(value),
                                        is_model_dict=True) \
            and APIHelper.is_valid_type(value=dictionary.get('arrival'),
                                        type_callable=lambda value: Arrival2.validate(value),
                                        is_model_dict=True) \
            and APIHelper.is_valid_type(value=dictionary.get('airline'),
                                        type_callable=lambda value: Airline2.validate(value),
                                        is_model_dict=True) \
            and APIHelper.is_valid_type(value=dictionary.get('flight'),
                                        type_callable=lambda value: Flight2.validate(value),
                                        is_model_dict=True) \
            and UnionTypeLookUp.get('Datum2Aircraft').validate(dictionary.get('aircraft')).is_valid \
            and APIHelper.is_valid_type(value=dictionary.get('live'),
                                        type_callable=lambda value: isinstance(value, str),
                                        is_value_nullable=True)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'flight_date={self.flight_date!r}, '
                f'flight_status={self.flight_status!r}, '
                f'departure={self.departure!r}, '
                f'arrival={self.arrival!r}, '
                f'airline={self.airline!r}, '
                f'flight={self.flight!r}, '
                f'aircraft={self.aircraft!r}, '
                f'live={self.live!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'flight_date={self.flight_date!s}, '
                f'flight_status={self.flight_status!s}, '
                f'departure={self.departure!s}, '
                f'arrival={self.arrival!s}, '
                f'airline={self.airline!s}, '
                f'flight={self.flight!s}, '
                f'aircraft={self.aircraft!s}, '
                f'live={self.live!s})')
