# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper
from aviationstack.models.airline_6 import Airline6
from aviationstack.models.arrival_6 import Arrival6
from aviationstack.models.departure_6 import Departure6
from aviationstack.models.flight_8 import Flight8


class Datum20(object):

    """Implementation of the 'Datum20' model.

    Attributes:
        airline (Airline6): The model property of type Airline6.
        arrival (Arrival6): The model property of type Arrival6.
        codeshared (Codeshared6 | None | Codeshared61): The model property of
            type Codeshared6 | None | Codeshared61.
        departure (Departure6): The model property of type Departure6.
        flight (Flight8): The model property of type Flight8.
        status (str): The model property of type str.
        mtype (str): The model property of type str.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "airline": 'airline',
        "arrival": 'arrival',
        "codeshared": 'codeshared',
        "departure": 'departure',
        "flight": 'flight',
        "status": 'status',
        "mtype": 'type'
    }

    _nullables = [
        'codeshared',
    ]

    def __init__(self,
                 airline=None,
                 arrival=None,
                 codeshared=None,
                 departure=None,
                 flight=None,
                 status=None,
                 mtype=None):
        """Constructor for the Datum20 class"""

        # Initialize members of the class
        self.airline = airline 
        self.arrival = arrival 
        self.codeshared = codeshared 
        self.departure = departure 
        self.flight = flight 
        self.status = status 
        self.mtype = mtype 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        from aviationstack.utilities.union_type_lookup import UnionTypeLookUp

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        airline = Airline6.from_dictionary(dictionary.get('airline')) if dictionary.get('airline') else None
        arrival = Arrival6.from_dictionary(dictionary.get('arrival')) if dictionary.get('arrival') else None
        codeshared = APIHelper.deserialize_union_type(UnionTypeLookUp.get('Datum20Codeshared'), dictionary.get('codeshared'), False) if dictionary.get('codeshared') is not None else None
        departure = Departure6.from_dictionary(dictionary.get('departure')) if dictionary.get('departure') else None
        flight = Flight8.from_dictionary(dictionary.get('flight')) if dictionary.get('flight') else None
        status = dictionary.get("status") if dictionary.get("status") else None
        mtype = dictionary.get("type") if dictionary.get("type") else None
        # Return an object of this model
        return cls(airline,
                   arrival,
                   codeshared,
                   departure,
                   flight,
                   status,
                   mtype)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """
        from aviationstack.utilities.union_type_lookup import UnionTypeLookUp

        if isinstance(dictionary, cls):
            return APIHelper.is_valid_type(value=dictionary.airline,
                                           type_callable=lambda value: Airline6.validate(value),
                                           is_model_dict=True) \
                and APIHelper.is_valid_type(value=dictionary.arrival,
                                            type_callable=lambda value: Arrival6.validate(value),
                                            is_model_dict=True) \
                and UnionTypeLookUp.get('Datum20Codeshared').validate(dictionary.codeshared).is_valid \
                and APIHelper.is_valid_type(value=dictionary.departure,
                                            type_callable=lambda value: Departure6.validate(value),
                                            is_model_dict=True) \
                and APIHelper.is_valid_type(value=dictionary.flight,
                                            type_callable=lambda value: Flight8.validate(value),
                                            is_model_dict=True) \
                and APIHelper.is_valid_type(value=dictionary.status,
                                            type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.mtype,
                                            type_callable=lambda value: isinstance(value, str))

        if not isinstance(dictionary, dict):
            return False

        return APIHelper.is_valid_type(value=dictionary.get('airline'),
                                       type_callable=lambda value: Airline6.validate(value),
                                       is_model_dict=True) \
            and APIHelper.is_valid_type(value=dictionary.get('arrival'),
                                        type_callable=lambda value: Arrival6.validate(value),
                                        is_model_dict=True) \
            and UnionTypeLookUp.get('Datum20Codeshared').validate(dictionary.get('codeshared')).is_valid \
            and APIHelper.is_valid_type(value=dictionary.get('departure'),
                                        type_callable=lambda value: Departure6.validate(value),
                                        is_model_dict=True) \
            and APIHelper.is_valid_type(value=dictionary.get('flight'),
                                        type_callable=lambda value: Flight8.validate(value),
                                        is_model_dict=True) \
            and APIHelper.is_valid_type(value=dictionary.get('status'),
                                        type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('type'),
                                        type_callable=lambda value: isinstance(value, str))

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'airline={self.airline!r}, '
                f'arrival={self.arrival!r}, '
                f'codeshared={self.codeshared!r}, '
                f'departure={self.departure!r}, '
                f'flight={self.flight!r}, '
                f'status={self.status!r}, '
                f'mtype={self.mtype!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'airline={self.airline!s}, '
                f'arrival={self.arrival!s}, '
                f'codeshared={self.codeshared!s}, '
                f'departure={self.departure!s}, '
                f'flight={self.flight!s}, '
                f'status={self.status!s}, '
                f'mtype={self.mtype!s})')
