# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper
from aviationstack.models.aircraft_4 import Aircraft4
from aviationstack.models.airline_6 import Airline6
from aviationstack.models.arrival_8 import Arrival8
from aviationstack.models.codeshared_61 import Codeshared61
from aviationstack.models.departure_8 import Departure8
from aviationstack.models.flight_6 import Flight6


class Datum22(object):

    """Implementation of the 'Datum22' model.

    Attributes:
        weekday (str): The model property of type str.
        departure (Departure8): The model property of type Departure8.
        arrival (Arrival8): The model property of type Arrival8.
        aircraft (Aircraft4): The model property of type Aircraft4.
        airline (Airline6): The model property of type Airline6.
        flight (Flight6): The model property of type Flight6.
        codeshared (Codeshared61): The model property of type Codeshared61.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "weekday": 'weekday',
        "departure": 'departure',
        "arrival": 'arrival',
        "aircraft": 'aircraft',
        "airline": 'airline',
        "flight": 'flight',
        "codeshared": 'codeshared'
    }

    _optionals = [
        'codeshared',
    ]

    def __init__(self,
                 weekday=None,
                 departure=None,
                 arrival=None,
                 aircraft=None,
                 airline=None,
                 flight=None,
                 codeshared=APIHelper.SKIP):
        """Constructor for the Datum22 class"""

        # Initialize members of the class
        self.weekday = weekday 
        self.departure = departure 
        self.arrival = arrival 
        self.aircraft = aircraft 
        self.airline = airline 
        self.flight = flight 
        if codeshared is not APIHelper.SKIP:
            self.codeshared = codeshared 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        weekday = dictionary.get("weekday") if dictionary.get("weekday") else None
        departure = Departure8.from_dictionary(dictionary.get('departure')) if dictionary.get('departure') else None
        arrival = Arrival8.from_dictionary(dictionary.get('arrival')) if dictionary.get('arrival') else None
        aircraft = Aircraft4.from_dictionary(dictionary.get('aircraft')) if dictionary.get('aircraft') else None
        airline = Airline6.from_dictionary(dictionary.get('airline')) if dictionary.get('airline') else None
        flight = Flight6.from_dictionary(dictionary.get('flight')) if dictionary.get('flight') else None
        codeshared = Codeshared61.from_dictionary(dictionary.get('codeshared')) if 'codeshared' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(weekday,
                   departure,
                   arrival,
                   aircraft,
                   airline,
                   flight,
                   codeshared)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'weekday={self.weekday!r}, '
                f'departure={self.departure!r}, '
                f'arrival={self.arrival!r}, '
                f'aircraft={self.aircraft!r}, '
                f'airline={self.airline!r}, '
                f'flight={self.flight!r}, '
                f'codeshared={(self.codeshared if hasattr(self, "codeshared") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'weekday={self.weekday!s}, '
                f'departure={self.departure!s}, '
                f'arrival={self.arrival!s}, '
                f'aircraft={self.aircraft!s}, '
                f'airline={self.airline!s}, '
                f'flight={self.flight!s}, '
                f'codeshared={(self.codeshared if hasattr(self, "codeshared") else None)!s})')
