# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.models.airline_4 import Airline4
from aviationstack.models.arrival_4 import Arrival4
from aviationstack.models.departure_4 import Departure4
from aviationstack.models.flight_4 import Flight4


class Datum4(object):

    """Implementation of the 'Datum4' model.

    Attributes:
        departure (Departure4): The model property of type Departure4.
        arrival (Arrival4): The model property of type Arrival4.
        airline (Airline4): The model property of type Airline4.
        flight (Flight4): The model property of type Flight4.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "departure": 'departure',
        "arrival": 'arrival',
        "airline": 'airline',
        "flight": 'flight'
    }

    def __init__(self,
                 departure=None,
                 arrival=None,
                 airline=None,
                 flight=None):
        """Constructor for the Datum4 class"""

        # Initialize members of the class
        self.departure = departure 
        self.arrival = arrival 
        self.airline = airline 
        self.flight = flight 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        departure = Departure4.from_dictionary(dictionary.get('departure')) if dictionary.get('departure') else None
        arrival = Arrival4.from_dictionary(dictionary.get('arrival')) if dictionary.get('arrival') else None
        airline = Airline4.from_dictionary(dictionary.get('airline')) if dictionary.get('airline') else None
        flight = Flight4.from_dictionary(dictionary.get('flight')) if dictionary.get('flight') else None
        # Return an object of this model
        return cls(departure,
                   arrival,
                   airline,
                   flight)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'departure={self.departure!r}, '
                f'arrival={self.arrival!r}, '
                f'airline={self.airline!r}, '
                f'flight={self.flight!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'departure={self.departure!s}, '
                f'arrival={self.arrival!s}, '
                f'airline={self.airline!s}, '
                f'flight={self.flight!s})')
