# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Departure6(object):

    """Implementation of the 'Departure6' model.

    Attributes:
        actual_runway (str): The model property of type str.
        actual_time (str): The model property of type str.
        baggage (str): The model property of type str.
        delay (str): The model property of type str.
        estimated_runway (str): The model property of type str.
        estimated_time (str): The model property of type str.
        gate (str): The model property of type str.
        iata_code (str): The model property of type str.
        icao_code (str): The model property of type str.
        scheduled_time (str): The model property of type str.
        terminal (str): The model property of type str.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "actual_runway": 'actualRunway',
        "actual_time": 'actualTime',
        "baggage": 'baggage',
        "delay": 'delay',
        "estimated_runway": 'estimatedRunway',
        "estimated_time": 'estimatedTime',
        "gate": 'gate',
        "iata_code": 'iataCode',
        "icao_code": 'icaoCode',
        "scheduled_time": 'scheduledTime',
        "terminal": 'terminal'
    }

    _nullables = [
        'actual_runway',
        'actual_time',
        'baggage',
        'delay',
        'estimated_runway',
        'estimated_time',
        'gate',
        'terminal',
    ]

    def __init__(self,
                 actual_runway=None,
                 actual_time=None,
                 baggage=None,
                 delay=None,
                 estimated_runway=None,
                 estimated_time=None,
                 gate=None,
                 iata_code=None,
                 icao_code=None,
                 scheduled_time=None,
                 terminal=None):
        """Constructor for the Departure6 class"""

        # Initialize members of the class
        self.actual_runway = actual_runway 
        self.actual_time = actual_time 
        self.baggage = baggage 
        self.delay = delay 
        self.estimated_runway = estimated_runway 
        self.estimated_time = estimated_time 
        self.gate = gate 
        self.iata_code = iata_code 
        self.icao_code = icao_code 
        self.scheduled_time = scheduled_time 
        self.terminal = terminal 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        actual_runway = dictionary.get("actualRunway") if dictionary.get("actualRunway") else None
        actual_time = dictionary.get("actualTime") if dictionary.get("actualTime") else None
        baggage = dictionary.get("baggage") if dictionary.get("baggage") else None
        delay = dictionary.get("delay") if dictionary.get("delay") else None
        estimated_runway = dictionary.get("estimatedRunway") if dictionary.get("estimatedRunway") else None
        estimated_time = dictionary.get("estimatedTime") if dictionary.get("estimatedTime") else None
        gate = dictionary.get("gate") if dictionary.get("gate") else None
        iata_code = dictionary.get("iataCode") if dictionary.get("iataCode") else None
        icao_code = dictionary.get("icaoCode") if dictionary.get("icaoCode") else None
        scheduled_time = dictionary.get("scheduledTime") if dictionary.get("scheduledTime") else None
        terminal = dictionary.get("terminal") if dictionary.get("terminal") else None
        # Return an object of this model
        return cls(actual_runway,
                   actual_time,
                   baggage,
                   delay,
                   estimated_runway,
                   estimated_time,
                   gate,
                   iata_code,
                   icao_code,
                   scheduled_time,
                   terminal)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return APIHelper.is_valid_type(value=dictionary.actual_runway,
                                           type_callable=lambda value: isinstance(value, str),
                                           is_value_nullable=True) \
                and APIHelper.is_valid_type(value=dictionary.actual_time,
                                            type_callable=lambda value: isinstance(value, str),
                                            is_value_nullable=True) \
                and APIHelper.is_valid_type(value=dictionary.baggage,
                                            type_callable=lambda value: isinstance(value, str),
                                            is_value_nullable=True) \
                and APIHelper.is_valid_type(value=dictionary.delay,
                                            type_callable=lambda value: isinstance(value, str),
                                            is_value_nullable=True) \
                and APIHelper.is_valid_type(value=dictionary.estimated_runway,
                                            type_callable=lambda value: isinstance(value, str),
                                            is_value_nullable=True) \
                and APIHelper.is_valid_type(value=dictionary.estimated_time,
                                            type_callable=lambda value: isinstance(value, str),
                                            is_value_nullable=True) \
                and APIHelper.is_valid_type(value=dictionary.gate,
                                            type_callable=lambda value: isinstance(value, str),
                                            is_value_nullable=True) \
                and APIHelper.is_valid_type(value=dictionary.iata_code,
                                            type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.icao_code,
                                            type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.scheduled_time,
                                            type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.terminal,
                                            type_callable=lambda value: isinstance(value, str),
                                            is_value_nullable=True)

        if not isinstance(dictionary, dict):
            return False

        return APIHelper.is_valid_type(value=dictionary.get('actualRunway'),
                                       type_callable=lambda value: isinstance(value, str),
                                       is_value_nullable=True) \
            and APIHelper.is_valid_type(value=dictionary.get('actualTime'),
                                        type_callable=lambda value: isinstance(value, str),
                                        is_value_nullable=True) \
            and APIHelper.is_valid_type(value=dictionary.get('baggage'),
                                        type_callable=lambda value: isinstance(value, str),
                                        is_value_nullable=True) \
            and APIHelper.is_valid_type(value=dictionary.get('delay'),
                                        type_callable=lambda value: isinstance(value, str),
                                        is_value_nullable=True) \
            and APIHelper.is_valid_type(value=dictionary.get('estimatedRunway'),
                                        type_callable=lambda value: isinstance(value, str),
                                        is_value_nullable=True) \
            and APIHelper.is_valid_type(value=dictionary.get('estimatedTime'),
                                        type_callable=lambda value: isinstance(value, str),
                                        is_value_nullable=True) \
            and APIHelper.is_valid_type(value=dictionary.get('gate'),
                                        type_callable=lambda value: isinstance(value, str),
                                        is_value_nullable=True) \
            and APIHelper.is_valid_type(value=dictionary.get('iataCode'),
                                        type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('icaoCode'),
                                        type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('scheduledTime'),
                                        type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('terminal'),
                                        type_callable=lambda value: isinstance(value, str),
                                        is_value_nullable=True)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'actual_runway={self.actual_runway!r}, '
                f'actual_time={self.actual_time!r}, '
                f'baggage={self.baggage!r}, '
                f'delay={self.delay!r}, '
                f'estimated_runway={self.estimated_runway!r}, '
                f'estimated_time={self.estimated_time!r}, '
                f'gate={self.gate!r}, '
                f'iata_code={self.iata_code!r}, '
                f'icao_code={self.icao_code!r}, '
                f'scheduled_time={self.scheduled_time!r}, '
                f'terminal={self.terminal!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'actual_runway={self.actual_runway!s}, '
                f'actual_time={self.actual_time!s}, '
                f'baggage={self.baggage!s}, '
                f'delay={self.delay!s}, '
                f'estimated_runway={self.estimated_runway!s}, '
                f'estimated_time={self.estimated_time!s}, '
                f'gate={self.gate!s}, '
                f'iata_code={self.iata_code!s}, '
                f'icao_code={self.icao_code!s}, '
                f'scheduled_time={self.scheduled_time!s}, '
                f'terminal={self.terminal!s})')
