# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Flight(object):

    """Implementation of the 'Flight' model.

    Attributes:
        number (str): The model property of type str.
        iata (str): The model property of type str.
        icao (str): The model property of type str.
        codeshared (Codeshared | None | Codeshared1): The model property of
            type Codeshared | None | Codeshared1.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "number": 'number',
        "iata": 'iata',
        "icao": 'icao',
        "codeshared": 'codeshared'
    }

    _nullables = [
        'iata',
        'icao',
        'codeshared',
    ]

    def __init__(self,
                 number=None,
                 iata=None,
                 icao=None,
                 codeshared=None):
        """Constructor for the Flight class"""

        # Initialize members of the class
        self.number = number 
        self.iata = iata 
        self.icao = icao 
        self.codeshared = codeshared 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        from aviationstack.utilities.union_type_lookup import UnionTypeLookUp

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        number = dictionary.get("number") if dictionary.get("number") else None
        iata = dictionary.get("iata") if dictionary.get("iata") else None
        icao = dictionary.get("icao") if dictionary.get("icao") else None
        codeshared = APIHelper.deserialize_union_type(UnionTypeLookUp.get('FlightCodeshared'), dictionary.get('codeshared'), False) if dictionary.get('codeshared') is not None else None
        # Return an object of this model
        return cls(number,
                   iata,
                   icao,
                   codeshared)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """
        from aviationstack.utilities.union_type_lookup import UnionTypeLookUp

        if isinstance(dictionary, cls):
            return APIHelper.is_valid_type(value=dictionary.number,
                                           type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.iata,
                                            type_callable=lambda value: isinstance(value, str),
                                            is_value_nullable=True) \
                and APIHelper.is_valid_type(value=dictionary.icao,
                                            type_callable=lambda value: isinstance(value, str),
                                            is_value_nullable=True) \
                and UnionTypeLookUp.get('FlightCodeshared').validate(dictionary.codeshared).is_valid

        if not isinstance(dictionary, dict):
            return False

        return APIHelper.is_valid_type(value=dictionary.get('number'),
                                       type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('iata'),
                                        type_callable=lambda value: isinstance(value, str),
                                        is_value_nullable=True) \
            and APIHelper.is_valid_type(value=dictionary.get('icao'),
                                        type_callable=lambda value: isinstance(value, str),
                                        is_value_nullable=True) \
            and UnionTypeLookUp.get('FlightCodeshared').validate(dictionary.get('codeshared')).is_valid

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'number={self.number!r}, '
                f'iata={self.iata!r}, '
                f'icao={self.icao!r}, '
                f'codeshared={self.codeshared!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'number={self.number!s}, '
                f'iata={self.iata!s}, '
                f'icao={self.icao!s}, '
                f'codeshared={self.codeshared!s})')
