# -*- coding: utf-8 -*-

"""
aviationstack

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from aviationstack.api_helper import APIHelper


class Flight8(object):

    """Implementation of the 'Flight8' model.

    Attributes:
        iata_number (str): The model property of type str.
        icao_number (str): The model property of type str.
        number (str): The model property of type str.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "iata_number": 'iataNumber',
        "icao_number": 'icaoNumber',
        "number": 'number'
    }

    _nullables = [
        'number',
    ]

    def __init__(self,
                 iata_number=None,
                 icao_number=None,
                 number=None):
        """Constructor for the Flight8 class"""

        # Initialize members of the class
        self.iata_number = iata_number 
        self.icao_number = icao_number 
        self.number = number 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        iata_number = dictionary.get("iataNumber") if dictionary.get("iataNumber") else None
        icao_number = dictionary.get("icaoNumber") if dictionary.get("icaoNumber") else None
        number = dictionary.get("number") if dictionary.get("number") else None
        # Return an object of this model
        return cls(iata_number,
                   icao_number,
                   number)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return APIHelper.is_valid_type(value=dictionary.iata_number,
                                           type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.icao_number,
                                            type_callable=lambda value: isinstance(value, str)) \
                and APIHelper.is_valid_type(value=dictionary.number,
                                            type_callable=lambda value: isinstance(value, str),
                                            is_value_nullable=True)

        if not isinstance(dictionary, dict):
            return False

        return APIHelper.is_valid_type(value=dictionary.get('iataNumber'),
                                       type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('icaoNumber'),
                                        type_callable=lambda value: isinstance(value, str)) \
            and APIHelper.is_valid_type(value=dictionary.get('number'),
                                        type_callable=lambda value: isinstance(value, str),
                                        is_value_nullable=True)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'iata_number={self.iata_number!r}, '
                f'icao_number={self.icao_number!r}, '
                f'number={self.number!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'iata_number={self.iata_number!s}, '
                f'icao_number={self.icao_number!s}, '
                f'number={self.number!s})')
