"""create_power_table_and_drop_measurement_table

Revision ID: 11b735abebe7
Revises: 1e8d27922f56
Create Date: 2018-05-29 14:51:30.331230

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "11b735abebe7"
down_revision = "1e8d27922f56"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "power",
        sa.Column("datetime", sa.DateTime(timezone=True), nullable=False),
        sa.Column("asset_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.Float(), nullable=False),
        sa.ForeignKeyConstraint(["asset_id"], ["asset.id"]),
        sa.PrimaryKeyConstraint("datetime", "asset_id"),
    )
    op.drop_table("measurement")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "measurement",
        sa.Column(
            "datetime",
            postgresql.TIMESTAMP(timezone=True),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column("asset_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column(
            "value",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["asset_id"], ["asset.id"], name="measurement_asset_id_fkey"
        ),
        sa.PrimaryKeyConstraint("datetime", "asset_id", name="measurement_pkey"),
    )
    op.drop_table("power")
    # ### end Alembic commands ###
