"""Add forecasting_job table

Revision ID: 1b64acf01809
Revises: 1a4f0e5c4b86
Create Date: 2018-08-31 15:09:09.462860

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "1b64acf01809"
down_revision = "1a4f0e5c4b86"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "forecasting_job",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("timed_value_type", sa.String(length=30), nullable=False),
        sa.Column("asset_id", sa.Integer(), nullable=False),
        sa.Column("start", sa.DateTime(timezone=True), nullable=False),
        sa.Column("end", sa.DateTime(timezone=True), nullable=False),
        sa.Column("horizon", sa.Interval(), nullable=False),
        sa.Column("in_progress_since", sa.DateTime(timezone=True), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("forecasting_job")
    # ### end Alembic commands ###
