""" delete assets and power measurements when asset owner is deleted

Revision ID: 26373d8266db
Revises: 1bcccdf0c3e1
Create Date: 2018-08-08 13:45:19.717975

"""
from alembic import op


# revision identifiers, used by Alembic.
revision = "26373d8266db"
down_revision = "1bcccdf0c3e1"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("asset_owner_id_bvp_users_fkey", "asset", type_="foreignkey")
    op.create_foreign_key(
        None, "asset", "bvp_users", ["owner_id"], ["id"], ondelete="CASCADE"
    )
    op.drop_constraint("power_asset_id_asset_fkey", "power", type_="foreignkey")
    op.create_foreign_key(
        None, "power", "asset", ["asset_id"], ["id"], ondelete="CASCADE"
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "power", type_="foreignkey")
    op.create_foreign_key(
        "power_asset_id_asset_fkey", "power", "asset", ["asset_id"], ["id"]
    )
    op.drop_constraint(None, "asset", type_="foreignkey")
    op.create_foreign_key(
        "asset_owner_id_bvp_users_fkey", "asset", "bvp_users", ["owner_id"], ["id"]
    )
    # ### end Alembic commands ###
