/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.pickle;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class ByteBufferInputStream
extends InputStream {
    private LinkedList<ByteBuffer> buffers = new LinkedList();

    public void put(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.buffers.add(byteBuffer);
    }

    @Override
    public int read() throws IOException {
        if (this.buffers.isEmpty()) {
            return -1;
        }
        ByteBuffer byteBuffer = this.buffers.getFirst();
        while (byteBuffer.remaining() == 0) {
            this.buffers.removeFirst();
            if (this.buffers.isEmpty()) {
                return -1;
            }
            byteBuffer = this.buffers.getFirst();
        }
        return byteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("Buffer cannot be null");
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("Invalid offset/length parameters");
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        while (n2 > 0 && !this.buffers.isEmpty()) {
            ByteBuffer byteBuffer = this.buffers.getFirst();
            int n4 = byteBuffer.remaining();
            if (n4 == 0) {
                this.buffers.removeFirst();
                continue;
            }
            int n5 = Math.min(n2, n4);
            byteBuffer.get(byArray, n, n5);
            n3 += n5;
            n2 -= n5;
            n += n5;
        }
        return n3 == 0 ? -1 : n3;
    }

    @Override
    public void close() throws IOException {
        this.buffers.clear();
    }
}

