'''List of automatic COCOS transformations

-------
'''
# COCOS signals candidates are generated by running utilities/generate_cocos_signals.py
# Running this script is useful to keep track of new signals that IMAS adds in new data structure releases
#
# In this file you are only allowed to edit/add entries to the `cocos_signals` dictionary
# The comments indicate `#[ADD_OR_DELETE_SUGGESTION]# MATCHING_SCORE # RATIONALE_FOR_ADD_OR_DELETE`
#
# Proceed as follows:
# 1. Edit transformations in this file (if a signal is missing, it can be added here)
# 2. Run `utilities/generate_cocos_signals.py` (which will update this same file)
# 3. Commit changes

cocos_signals = {}

# AMNS_DATA

# BAROMETRY
cocos_signals['barometry.gauge.:.position.phi']='?'                      #[ADD?]# 2.000000 # phi  [rad]

# BOLOMETER
cocos_signals['bolometer.channel.:.aperture.:.centre.phi']='TOR'                         # 2.000000 # phi  [rad]
cocos_signals['bolometer.channel.:.detector.centre.phi']='TOR'                           # 2.000000 # phi  [rad]
cocos_signals['bolometer.channel.:.line_of_sight.first_point.phi']='TOR'                 # 2.000000 # phi  [rad]
cocos_signals['bolometer.channel.:.line_of_sight.second_point.phi']='TOR'                # 2.000000 # phi  [rad]
cocos_signals['bolometer.channel.:.line_of_sight.third_point.phi']='TOR'                 # 2.000000 # phi  [rad]

# CHARGE_EXCHANGE
cocos_signals['charge_exchange.channel.:.ion.:.velocity_pol.data']='?'                                  #[ADD?]# 2.666667 # velocity  _pol  [m.s^-1]
cocos_signals['charge_exchange.channel.:.ion.:.velocity_tor.data']='?'                                  #[ADD?]# 2.666667 # velocity  _tor  [m.s^-1]
cocos_signals['charge_exchange.channel.:.momentum_tor.data']='?'                                        #[ADD?]# 2.500000 # momentum  _tor  [kg.m^-1.s^-1]
cocos_signals['charge_exchange.aperture.centre.phi']='?'                                                #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['charge_exchange.channel.:.position.phi.data']='?'                                        #[ADD?]# 1.800000 # phi  [rad]

# COILS_NON_AXISYMMETRIC
cocos_signals['coils_non_axisymmetric.coil.:.conductor.:.elements.centres.phi']='?'                       #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['coils_non_axisymmetric.coil.:.conductor.:.elements.end_points.phi']='?'                    #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['coils_non_axisymmetric.coil.:.conductor.:.elements.intermediate_points.phi']='?'           #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['coils_non_axisymmetric.coil.:.conductor.:.elements.start_points.phi']='?'                  #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['coils_non_axisymmetric.coil.:.conductor.:.current.data']='?'                               #[ADD?]# 1.833333 # current  [A]
cocos_signals['coils_non_axisymmetric.coil.:.current.data']='?'                                           #[ADD?]# 1.750000 # current  [A]

# CONTROLLERS

# CORE_INSTANT_CHANGES
cocos_signals['core_instant_changes.change.:.profiles_1d.:.e_field_parallel']='?'                                                  #[ADD?]# 3.000000 # e_field  parallel  [V.m^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.electrons.velocity_pol']='?'                                            #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.electrons.velocity_tor']='?'                                            #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.velocity_pol']='?'                                                #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.velocity_tor']='?'                                                #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.j_tor']='?'                                                             #[ADD?]# 3.000000 # j  _tor  [A/m^2]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.momentum_tor']='?'                                                      #[ADD?]# 3.000000 # momentum  _tor  [kg.m^-1.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.state.:.velocity.parallel']='?'                                   #[ADD?]# 2.900000 # velocity  parallel  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.state.:.velocity.poloidal']='?'                                   #[ADD?]# 2.900000 # velocity  poloidal  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.state.:.velocity.toroidal']='?'                                   #[ADD?]# 2.900000 # velocity  toroidal  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.state.:.velocity.parallel']='?'                               #[ADD?]# 2.900000 # velocity  parallel  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.state.:.velocity.poloidal']='?'                               #[ADD?]# 2.900000 # velocity  poloidal  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.state.:.velocity.toroidal']='?'                               #[ADD?]# 2.900000 # velocity  toroidal  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.velocity.parallel']='?'                                           #[ADD?]# 2.875000 # velocity  parallel  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.velocity.poloidal']='?'                                           #[ADD?]# 2.875000 # velocity  poloidal  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.velocity.toroidal']='?'                                           #[ADD?]# 2.875000 # velocity  toroidal  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.velocity.parallel']='?'                                       #[ADD?]# 2.875000 # velocity  parallel  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.velocity.poloidal']='?'                                       #[ADD?]# 2.875000 # velocity  poloidal  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.velocity.toroidal']='?'                                       #[ADD?]# 2.875000 # velocity  toroidal  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.electrons.velocity.parallel']='?'                                       #[ADD?]# 2.857143 # velocity  parallel  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.electrons.velocity.poloidal']='?'                                       #[ADD?]# 2.857143 # velocity  poloidal  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.electrons.velocity.toroidal']='?'                                       #[ADD?]# 2.857143 # velocity  toroidal  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.e_field.parallel']='?'                                                  #[ADD?]# 2.833333 # e_field  parallel  [V.m^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.e_field.poloidal']='?'                                                  #[ADD?]# 2.833333 # e_field  poloidal  [V.m^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.e_field.toroidal']='?'                                                  #[ADD?]# 2.833333 # e_field  toroidal  [V.m^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.current_parallel_inside']='?'                                           #[ADD?]# 2.000000 # current  [A]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.grid.psi']='?'                                                          #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.rotation_frequency_tor']='?'                                      #[ADD?]# 2.000000 # _tor  [rad.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.state.:.rotation_frequency_tor']='?'                              #[ADD?]# 2.000000 # _tor  [rad.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.j_bootstrap']='?'                                                       #[ADD?]# 2.000000 # j  [A/m^2]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.j_non_inductive']='?'                                                   #[ADD?]# 2.000000 # j  [A/m^2]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.j_ohmic']='?'                                                           #[ADD?]# 2.000000 # j  [A/m^2]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.j_total']='?'                                                           #[ADD?]# 2.000000 # j  [A/m^2]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.q']='?'                                                                 #[ADD?]# 2.000000 # q  [-]
cocos_signals['core_instant_changes.vacuum_toroidal_field.b0']='TOR'                                                                      # 2.000000 # b0  [T]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.state.:.velocity.diamagnetic']='?'                                #[ADD?]# 1.900000 # velocity  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.state.:.velocity.diamagnetic']='?'                            #[ADD?]# 1.900000 # velocity  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.ion.:.velocity.diamagnetic']='?'                                        #[ADD?]# 1.875000 # velocity  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.neutral.:.velocity.diamagnetic']='?'                                    #[ADD?]# 1.875000 # velocity  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.electrons.velocity.diamagnetic']='?'                                    #[ADD?]# 1.857143 # velocity  [m.s^-1]
cocos_signals['core_instant_changes.change.:.profiles_1d.:.e_field.diamagnetic']='?'                                               #[ADD?]# 1.833333 # e_field  [V.m^-1]

# CORE_PROFILES
cocos_signals['core_profiles.profiles_1d.:.e_field_parallel']='TOR'                                                       # 3.000000 # e_field  parallel  [V.m^-1]
cocos_signals['core_profiles.profiles_1d.:.electrons.velocity_pol']='POL'                                                 # 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.electrons.velocity_tor']='TOR'                                                 # 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.ion.:.velocity_pol']='POL'                                                     # 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.ion.:.velocity_tor']='TOR'                                                     # 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.j_tor']='TOR'                                                                  # 3.000000 # j  _tor  [A/m^2]
cocos_signals['core_profiles.profiles_1d.:.momentum_tor']='TOR'                                                           # 3.000000 # momentum  _tor  [kg.m^-1.s^-1]
cocos_signals['core_profiles.profiles_1d.:.ion.:.state.:.velocity.parallel']='TOR'                                        # 2.875000 # velocity  parallel  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.ion.:.state.:.velocity.poloidal']='POL'                                        # 2.875000 # velocity  poloidal  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.ion.:.state.:.velocity.toroidal']='TOR'                                        # 2.875000 # velocity  toroidal  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.neutral.:.state.:.velocity.parallel']='TOR'                                    # 2.875000 # velocity  parallel  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.neutral.:.state.:.velocity.poloidal']='POL'                                    # 2.875000 # velocity  poloidal  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.neutral.:.state.:.velocity.toroidal']='TOR'                                    # 2.875000 # velocity  toroidal  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.ion.:.velocity.parallel']='TOR'                                                # 2.833333 # velocity  parallel  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.ion.:.velocity.poloidal']='POL'                                                # 2.833333 # velocity  poloidal  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.ion.:.velocity.toroidal']='TOR'                                                # 2.833333 # velocity  toroidal  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.neutral.:.velocity.parallel']='TOR'                                            # 2.833333 # velocity  parallel  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.neutral.:.velocity.poloidal']='POL'                                            # 2.833333 # velocity  poloidal  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.neutral.:.velocity.toroidal']='TOR'                                            # 2.833333 # velocity  toroidal  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.electrons.velocity.parallel']='TOR'                                            # 2.800000 # velocity  parallel  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.electrons.velocity.poloidal']='POL'                                            # 2.800000 # velocity  poloidal  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.electrons.velocity.toroidal']='TOR'                                            # 2.800000 # velocity  toroidal  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.e_field.parallel']='TOR'                                                       # 2.750000 # e_field  parallel  [V.m^-1]
cocos_signals['core_profiles.profiles_1d.:.e_field.poloidal']='POL'                                                       # 2.750000 # e_field  poloidal  [V.m^-1]
cocos_signals['core_profiles.profiles_1d.:.e_field.toroidal']='TOR'                                                       # 2.750000 # e_field  toroidal  [V.m^-1]
cocos_signals['core_profiles.global_quantities.current_bootstrap']='TOR'                                                  # 2.000000 # current  [A]
cocos_signals['core_profiles.global_quantities.current_non_inductive']='TOR'                                              # 2.000000 # current  [A]
cocos_signals['core_profiles.global_quantities.ip']='TOR'                                                                 # 2.000000 # ip  [A]
cocos_signals['core_profiles.global_quantities.v_loop']='TOR'                                                             # 2.000000 # v  [V]
cocos_signals['core_profiles.profiles_1d.:.current_parallel_inside']='TOR'                                                # 2.000000 # current  [A]
cocos_signals['core_profiles.profiles_1d.:.grid.psi']='PSI'                                                               # 2.000000 # psi  [Wb]
cocos_signals['core_profiles.profiles_1d.:.ion.:.rotation_frequency_tor']='?'                                      #[ADD?]# 2.000000 # _tor  [rad.s^-1]
cocos_signals['core_profiles.profiles_1d.:.ion.:.state.:.rotation_frequency_tor']='?'                              #[ADD?]# 2.000000 # _tor  [rad.s^-1]
cocos_signals['core_profiles.profiles_1d.:.j_bootstrap']='TOR'                                                            # 2.000000 # j  [A/m^2]
cocos_signals['core_profiles.profiles_1d.:.j_non_inductive']='TOR'                                                        # 2.000000 # j  [A/m^2]
cocos_signals['core_profiles.profiles_1d.:.j_ohmic']='TOR'                                                                # 2.000000 # j  [A/m^2]
cocos_signals['core_profiles.profiles_1d.:.j_total']='TOR'                                                                # 2.000000 # j  [A/m^2]
cocos_signals['core_profiles.profiles_1d.:.q']='Q'                                                                        # 2.000000 # q  [-]
cocos_signals['core_profiles.vacuum_toroidal_field.b0']='TOR'                                                             # 2.000000 # b0  [T]
cocos_signals['core_profiles.profiles_1d.:.ion.:.state.:.velocity.diamagnetic']='TOR'                                     # 1.875000 # velocity  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.neutral.:.state.:.velocity.diamagnetic']='TOR'                                 # 1.875000 # velocity  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.ion.:.velocity.diamagnetic']='TOR'                                             # 1.833333 # velocity  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.neutral.:.velocity.diamagnetic']='TOR'                                         # 1.833333 # velocity  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.electrons.velocity.diamagnetic']='TOR'                                         # 1.800000 # velocity  [m.s^-1]
cocos_signals['core_profiles.profiles_1d.:.e_field.diamagnetic']='TOR'                                                    # 1.750000 # e_field  [V.m^-1]

# CORE_SOURCES
cocos_signals['core_sources.source.:.global_quantities.:.current_parallel']='TOR'                                          # 3.000000 # current  parallel  [A.m]
cocos_signals['core_sources.source.:.global_quantities.:.torque_tor']='TOR'                                                # 3.000000 # torque  _tor  [kg.m^2.s^-2]
cocos_signals['core_sources.source.:.profiles_1d.:.j_parallel']='TOR'                                                      # 3.000000 # j  parallel  [A.m^-2]
cocos_signals['core_sources.source.:.profiles_1d.:.momentum_tor']='TOR'                                                    # 3.000000 # momentum  _tor  [kg.m^-1.s^-2]
cocos_signals['core_sources.source.:.profiles_1d.:.ion.:.momentum.parallel']='?'                                    #[ADD?]# 2.875000 # momentum  parallel  [kg.m^-1.s^-2]
cocos_signals['core_sources.source.:.profiles_1d.:.ion.:.momentum.poloidal']='?'                                    #[ADD?]# 2.875000 # momentum  poloidal  [kg.m^-1.s^-2]
cocos_signals['core_sources.source.:.profiles_1d.:.ion.:.momentum.toroidal']='?'                                    #[ADD?]# 2.875000 # momentum  toroidal  [kg.m^-1.s^-2]
cocos_signals['core_sources.source.:.profiles_1d.:.ion.:.momentum.toroidal_decomposed.explicit_part']='?'           #[ADD?]# 2.666667 # momentum  toroidal  [kg.m^2.s^-2]
cocos_signals['core_sources.source.:.profiles_1d.:.ion.:.momentum.toroidal_decomposed.implicit_part']='?'           #[ADD?]# 2.666667 # momentum  toroidal  [s^-1]
cocos_signals['core_sources.source.:.profiles_1d.:.current_parallel_inside']='TOR'                                         # 2.000000 # current  [A]
cocos_signals['core_sources.source.:.profiles_1d.:.grid.psi']='PSI'                                                        # 2.000000 # psi  [Wb]
cocos_signals['core_sources.source.:.profiles_1d.:.torque_tor_inside']='TOR'                                               # 2.000000 # torque  [kg.m^2.s^-2]
cocos_signals['core_sources.vacuum_toroidal_field.b0']='TOR'                                                               # 2.000000 # b0  [T]
cocos_signals['core_sources.source.:.profiles_1d.:.ion.:.momentum.diamagnetic']='?'                                 #[ADD?]# 1.875000 # momentum  [kg.m^-1.s^-2]

# CORE_TRANSPORT
cocos_signals['core_transport.model.:.profiles_1d.:.grid_d.psi']='?'                                                     #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['core_transport.model.:.profiles_1d.:.grid_flux.psi']='?'                                                  #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['core_transport.model.:.profiles_1d.:.grid_v.psi']='?'                                                     #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['core_transport.vacuum_toroidal_field.b0']='TOR'                                                                  # 2.000000 # b0  [T]

# DATASET_DESCRIPTION

# DISTRIBUTION_SOURCES
cocos_signals['distribution_sources.source.:.global_quantities.:.shinethrough.torque_tor']='?'                             #[ADD?]# 3.000000 # torque  _tor  [N.m]
cocos_signals['distribution_sources.source.:.global_quantities.:.torque_tor']='?'                                          #[ADD?]# 3.000000 # torque  _tor  [N.m]
cocos_signals['distribution_sources.source.:.profiles_1d.:.momentum_tor']='?'                                              #[ADD?]# 3.000000 # momentum  _tor  [N.m^-2]
cocos_signals['distribution_sources.source.:.profiles_1d.:.grid.psi']='?'                                                  #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['distribution_sources.vacuum_toroidal_field.b0']='TOR'                                                              # 2.000000 # b0  [T]

# DISTRIBUTIONS
cocos_signals['distributions.distribution.:.global_quantities.:.collisions.electrons.torque_fast_tor']='?'                            #[ADD?]# 3.000000 # torque  _tor  [N.m]
cocos_signals['distributions.distribution.:.global_quantities.:.collisions.electrons.torque_thermal_tor']='?'                         #[ADD?]# 3.000000 # torque  _tor  [N.m]
cocos_signals['distributions.distribution.:.global_quantities.:.collisions.ion.:.state.:.torque_fast_tor']='?'                        #[ADD?]# 3.000000 # torque  _tor  [N.m]
cocos_signals['distributions.distribution.:.global_quantities.:.collisions.ion.:.state.:.torque_thermal_tor']='?'                     #[ADD?]# 3.000000 # torque  _tor  [N.m]
cocos_signals['distributions.distribution.:.global_quantities.:.collisions.ion.:.torque_fast_tor']='?'                                #[ADD?]# 3.000000 # torque  _tor  [N.m]
cocos_signals['distributions.distribution.:.global_quantities.:.collisions.ion.:.torque_thermal_tor']='?'                             #[ADD?]# 3.000000 # torque  _tor  [N.m]
cocos_signals['distributions.distribution.:.global_quantities.:.current_tor']='?'                                                     #[ADD?]# 3.000000 # current  _tor  [N.m]
cocos_signals['distributions.distribution.:.global_quantities.:.source.:.torque_tor']='?'                                             #[ADD?]# 3.000000 # torque  _tor  [N.m]
cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.collisions.electrons.torque_fast_tor']='?'                       #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.collisions.electrons.torque_thermal_tor']='?'                    #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.collisions.ion.:.state.:.torque_fast_tor']='?'                   #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.collisions.ion.:.state.:.torque_thermal_tor']='?'                #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.collisions.ion.:.torque_fast_tor']='?'                           #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.collisions.ion.:.torque_thermal_tor']='?'                        #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.current_fast_tor']='?'                                           #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.current_tor']='?'                                                #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.co_passing.source.:.momentum_tor']='?'                                      #[ADD?]# 3.000000 # momentum  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.collisions.electrons.torque_fast_tor']='?'                                  #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.collisions.electrons.torque_thermal_tor']='?'                               #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.collisions.ion.:.state.:.torque_fast_tor']='?'                              #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.collisions.ion.:.state.:.torque_thermal_tor']='?'                           #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.collisions.ion.:.torque_fast_tor']='?'                                      #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.collisions.ion.:.torque_thermal_tor']='?'                                   #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.collisions.electrons.torque_fast_tor']='?'                  #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.collisions.electrons.torque_thermal_tor']='?'               #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.collisions.ion.:.state.:.torque_fast_tor']='?'              #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.collisions.ion.:.state.:.torque_thermal_tor']='?'           #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.collisions.ion.:.torque_fast_tor']='?'                      #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.collisions.ion.:.torque_thermal_tor']='?'                   #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.current_fast_tor']='?'                                      #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.current_tor']='?'                                           #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.counter_passing.source.:.momentum_tor']='?'                                 #[ADD?]# 3.000000 # momentum  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.current_fast_tor']='?'                                                      #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.current_tor']='?'                                                           #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.source.:.momentum_tor']='?'                                                 #[ADD?]# 3.000000 # momentum  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.thermalisation.momentum_tor']='?'                                           #[ADD?]# 3.000000 # momentum  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.collisions.electrons.torque_fast_tor']='?'                          #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.collisions.electrons.torque_thermal_tor']='?'                       #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.collisions.ion.:.state.:.torque_fast_tor']='?'                      #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.collisions.ion.:.state.:.torque_thermal_tor']='?'                   #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.collisions.ion.:.torque_fast_tor']='?'                              #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.collisions.ion.:.torque_thermal_tor']='?'                           #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.current_fast_tor']='?'                                              #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.current_tor']='?'                                                   #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_1d.:.trapped.source.:.momentum_tor']='?'                                         #[ADD?]# 3.000000 # momentum  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.collisions.electrons.torque_fast_tor']='?'                       #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.collisions.electrons.torque_thermal_tor']='?'                    #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.collisions.ion.:.state.:.torque_fast_tor']='?'                   #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.collisions.ion.:.state.:.torque_thermal_tor']='?'                #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.collisions.ion.:.torque_fast_tor']='?'                           #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.collisions.ion.:.torque_thermal_tor']='?'                        #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.current_fast_tor']='?'                                           #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.co_passing.current_tor']='?'                                                #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.collisions.electrons.torque_fast_tor']='?'                                  #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.collisions.electrons.torque_thermal_tor']='?'                               #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.collisions.ion.:.state.:.torque_fast_tor']='?'                              #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.collisions.ion.:.state.:.torque_thermal_tor']='?'                           #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.collisions.ion.:.torque_fast_tor']='?'                                      #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.collisions.ion.:.torque_thermal_tor']='?'                                   #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.collisions.electrons.torque_fast_tor']='?'                  #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.collisions.electrons.torque_thermal_tor']='?'               #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.collisions.ion.:.state.:.torque_fast_tor']='?'              #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.collisions.ion.:.state.:.torque_thermal_tor']='?'           #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.collisions.ion.:.torque_fast_tor']='?'                      #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.collisions.ion.:.torque_thermal_tor']='?'                   #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.current_fast_tor']='?'                                      #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.counter_passing.current_tor']='?'                                           #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.current_fast_tor']='?'                                                      #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.current_tor']='?'                                                           #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.collisions.electrons.torque_fast_tor']='?'                          #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.collisions.electrons.torque_thermal_tor']='?'                       #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.collisions.ion.:.state.:.torque_fast_tor']='?'                      #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.collisions.ion.:.state.:.torque_thermal_tor']='?'                   #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.collisions.ion.:.torque_fast_tor']='?'                              #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.collisions.ion.:.torque_thermal_tor']='?'                           #[ADD?]# 3.000000 # torque  _tor  [N.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.current_fast_tor']='?'                                              #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.profiles_2d.:.trapped.current_tor']='?'                                                   #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['distributions.distribution.:.global_quantities.:.energy_fast_parallel']='?'                                            #[ADD?]# 2.000000 # parallel  [J]
cocos_signals['distributions.distribution.:.profiles_1d.:.grid.psi']='?'                                                              #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['distributions.distribution.:.profiles_2d.:.grid.psi']='?'                                                              #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['distributions.vacuum_toroidal_field.b0']='TOR'                                                                                # 2.000000 # b0  [T]

# EC_ANTENNAS
cocos_signals['ec_antennas.antenna.:.launching_position.phi.data']='?'           #[ADD?]# 1.800000 # phi  [rad]
cocos_signals['ec_antennas.antenna.:.launching_angle_pol.data']='?'              #[ADD?]# 1.750000 # _pol  [rad]
cocos_signals['ec_antennas.antenna.:.launching_angle_tor.data']='?'              #[ADD?]# 1.750000 # _tor  [rad]

# ECE
cocos_signals['ece.line_of_sight.first_point.phi']='?'                  #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['ece.line_of_sight.second_point.phi']='?'                 #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['ece.channel.:.position.phi.data']='?'                    #[ADD?]# 1.800000 # phi  [rad]
cocos_signals['ece.channel.:.position.psi.data']='?'                    #[ADD?]# 1.800000 # psi  [W]

# EDGE_PROFILES
cocos_signals['edge_profiles.profiles_1d.:.e_field_parallel']='?'                                                    #[ADD?]# 3.000000 # e_field  parallel  [V.m^-1]
cocos_signals['edge_profiles.profiles_1d.:.electrons.velocity_pol']='?'                                              #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.electrons.velocity_tor']='?'                                              #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.ion.:.velocity_pol']='?'                                                  #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.ion.:.velocity_tor']='?'                                                  #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.j_tor']='?'                                                               #[ADD?]# 3.000000 # j  _tor  [A/m^2]
cocos_signals['edge_profiles.profiles_1d.:.momentum_tor']='?'                                                        #[ADD?]# 3.000000 # momentum  _tor  [kg.m^-1.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.ion.:.state.:.velocity.parallel']='?'                                     #[ADD?]# 2.875000 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.ion.:.state.:.velocity.poloidal']='?'                                     #[ADD?]# 2.875000 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.ion.:.state.:.velocity.toroidal']='?'                                     #[ADD?]# 2.875000 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.neutral.:.state.:.velocity.parallel']='?'                                 #[ADD?]# 2.875000 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.neutral.:.state.:.velocity.poloidal']='?'                                 #[ADD?]# 2.875000 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.neutral.:.state.:.velocity.toroidal']='?'                                 #[ADD?]# 2.875000 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.ion.:.velocity.parallel']='?'                                             #[ADD?]# 2.833333 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.ion.:.velocity.poloidal']='?'                                             #[ADD?]# 2.833333 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.ion.:.velocity.toroidal']='?'                                             #[ADD?]# 2.833333 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.neutral.:.velocity.parallel']='?'                                         #[ADD?]# 2.833333 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.neutral.:.velocity.poloidal']='?'                                         #[ADD?]# 2.833333 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.neutral.:.velocity.toroidal']='?'                                         #[ADD?]# 2.833333 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.electrons.velocity.parallel']='?'                                         #[ADD?]# 2.800000 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.electrons.velocity.poloidal']='?'                                         #[ADD?]# 2.800000 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.electrons.velocity.toroidal']='?'                                         #[ADD?]# 2.800000 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity.:.parallel']='?'                                           #[ADD?]# 2.777778 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity.:.poloidal']='?'                                           #[ADD?]# 2.777778 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity.:.toroidal']='?'                                           #[ADD?]# 2.777778 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_diamagnetic.:.parallel']='?'                               #[ADD?]# 2.777778 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_diamagnetic.:.poloidal']='?'                               #[ADD?]# 2.777778 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_diamagnetic.:.toroidal']='?'                               #[ADD?]# 2.777778 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_exb.:.parallel']='?'                                       #[ADD?]# 2.777778 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_exb.:.poloidal']='?'                                       #[ADD?]# 2.777778 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_exb.:.toroidal']='?'                                       #[ADD?]# 2.777778 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity.:.parallel']='?'                                       #[ADD?]# 2.777778 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity.:.poloidal']='?'                                       #[ADD?]# 2.777778 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity.:.toroidal']='?'                                       #[ADD?]# 2.777778 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_diamagnetic.:.parallel']='?'                           #[ADD?]# 2.777778 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_diamagnetic.:.poloidal']='?'                           #[ADD?]# 2.777778 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_diamagnetic.:.toroidal']='?'                           #[ADD?]# 2.777778 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_exb.:.parallel']='?'                                   #[ADD?]# 2.777778 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_exb.:.poloidal']='?'                                   #[ADD?]# 2.777778 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_exb.:.toroidal']='?'                                   #[ADD?]# 2.777778 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.e_field.parallel']='?'                                                    #[ADD?]# 2.750000 # e_field  parallel  [V.m^-1]
cocos_signals['edge_profiles.profiles_1d.:.e_field.poloidal']='?'                                                    #[ADD?]# 2.750000 # e_field  poloidal  [V.m^-1]
cocos_signals['edge_profiles.profiles_1d.:.e_field.toroidal']='?'                                                    #[ADD?]# 2.750000 # e_field  toroidal  [V.m^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.velocity.:.parallel']='?'                                                   #[ADD?]# 2.714286 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.velocity.:.poloidal']='?'                                                   #[ADD?]# 2.714286 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.velocity.:.toroidal']='?'                                                   #[ADD?]# 2.714286 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.velocity.:.parallel']='?'                                               #[ADD?]# 2.714286 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.velocity.:.poloidal']='?'                                               #[ADD?]# 2.714286 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.velocity.:.toroidal']='?'                                               #[ADD?]# 2.714286 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.electrons.velocity.:.parallel']='?'                                               #[ADD?]# 2.666667 # velocity  parallel  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.electrons.velocity.:.poloidal']='?'                                               #[ADD?]# 2.666667 # velocity  poloidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.electrons.velocity.:.toroidal']='?'                                               #[ADD?]# 2.666667 # velocity  toroidal  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.e_field.:.parallel']='?'                                                          #[ADD?]# 2.600000 # e_field  parallel  [V.m^-1]
cocos_signals['edge_profiles.ggd.:.e_field.:.poloidal']='?'                                                          #[ADD?]# 2.600000 # e_field  poloidal  [V.m^-1]
cocos_signals['edge_profiles.ggd.:.e_field.:.toroidal']='?'                                                          #[ADD?]# 2.600000 # e_field  toroidal  [V.m^-1]
cocos_signals['edge_profiles.ggd.:.j_anomalous.:.parallel']='?'                                                      #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_anomalous.:.poloidal']='?'                                                      #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_anomalous.:.toroidal']='?'                                                      #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_diamagnetic.:.parallel']='?'                                                    #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_diamagnetic.:.poloidal']='?'                                                    #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_diamagnetic.:.toroidal']='?'                                                    #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_heat_viscosity.:.parallel']='?'                                                 #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_heat_viscosity.:.poloidal']='?'                                                 #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_heat_viscosity.:.toroidal']='?'                                                 #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_inertial.:.parallel']='?'                                                       #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_inertial.:.poloidal']='?'                                                       #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_inertial.:.toroidal']='?'                                                       #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_ion_neutral_friction.:.parallel']='?'                                           #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_ion_neutral_friction.:.poloidal']='?'                                           #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_ion_neutral_friction.:.toroidal']='?'                                           #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_parallel_viscosity.:.parallel']='?'                                             #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_parallel_viscosity.:.poloidal']='?'                                             #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_parallel_viscosity.:.toroidal']='?'                                             #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_perpendicular_viscosity.:.parallel']='?'                                        #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_perpendicular_viscosity.:.poloidal']='?'                                        #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_perpendicular_viscosity.:.toroidal']='?'                                        #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_pfirsch_schlueter.:.parallel']='?'                                              #[ADD?]# 2.600000 # j  parallel  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_pfirsch_schlueter.:.poloidal']='?'                                              #[ADD?]# 2.600000 # j  poloidal  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_pfirsch_schlueter.:.toroidal']='?'                                              #[ADD?]# 2.600000 # j  toroidal  [A.m^-2]
cocos_signals['edge_profiles.profiles_1d.:.current_parallel_inside']='?'                                             #[ADD?]# 2.000000 # current  [A]
cocos_signals['edge_profiles.profiles_1d.:.grid.psi']='?'                                                            #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['edge_profiles.profiles_1d.:.ion.:.rotation_frequency_tor']='?'                                        #[ADD?]# 2.000000 # _tor  [rad.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.ion.:.state.:.rotation_frequency_tor']='?'                                #[ADD?]# 2.000000 # _tor  [rad.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.j_bootstrap']='?'                                                         #[ADD?]# 2.000000 # j  [A/m^2]
cocos_signals['edge_profiles.profiles_1d.:.j_non_inductive']='?'                                                     #[ADD?]# 2.000000 # j  [A/m^2]
cocos_signals['edge_profiles.profiles_1d.:.j_ohmic']='?'                                                             #[ADD?]# 2.000000 # j  [A/m^2]
cocos_signals['edge_profiles.profiles_1d.:.j_total']='?'                                                             #[ADD?]# 2.000000 # j  [A/m^2]
cocos_signals['edge_profiles.profiles_1d.:.q']='?'                                                                   #[ADD?]# 2.000000 # q  [-]
cocos_signals['edge_profiles.vacuum_toroidal_field.b0']='TOR'                                                               # 2.000000 # b0  [T]
cocos_signals['edge_profiles.profiles_1d.:.ion.:.state.:.velocity.diamagnetic']='?'                                  #[ADD?]# 1.875000 # velocity  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.neutral.:.state.:.velocity.diamagnetic']='?'                              #[ADD?]# 1.875000 # velocity  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.ion.:.velocity.diamagnetic']='?'                                          #[ADD?]# 1.833333 # velocity  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.neutral.:.velocity.diamagnetic']='?'                                      #[ADD?]# 1.833333 # velocity  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.electrons.velocity.diamagnetic']='?'                                      #[ADD?]# 1.800000 # velocity  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity.:.diamagnetic']='?'                                        #[ADD?]# 1.777778 # velocity  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_diamagnetic.:.diamagnetic']='?'                            #[ADD?]# 1.777778 # velocity  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.state.:.velocity_exb.:.diamagnetic']='?'                                    #[ADD?]# 1.777778 # velocity  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity.:.diamagnetic']='?'                                    #[ADD?]# 1.777778 # velocity  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_diamagnetic.:.diamagnetic']='?'                        #[ADD?]# 1.777778 # velocity  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.state.:.velocity_exb.:.diamagnetic']='?'                                #[ADD?]# 1.777778 # velocity  [m.s^-1]
cocos_signals['edge_profiles.profiles_1d.:.e_field.diamagnetic']='?'                                                 #[ADD?]# 1.750000 # e_field  [V.m^-1]
cocos_signals['edge_profiles.ggd.:.ion.:.velocity.:.diamagnetic']='?'                                                #[ADD?]# 1.714286 # velocity  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.neutral.:.velocity.:.diamagnetic']='?'                                            #[ADD?]# 1.714286 # velocity  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.electrons.velocity.:.diamagnetic']='?'                                            #[ADD?]# 1.666667 # velocity  [m.s^-1]
cocos_signals['edge_profiles.ggd.:.e_field.:.diamagnetic']='?'                                                       #[ADD?]# 1.600000 # e_field  [V.m^-1]
cocos_signals['edge_profiles.ggd.:.j_anomalous.:.diamagnetic']='?'                                                   #[ADD?]# 1.600000 # j  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_diamagnetic.:.diamagnetic']='?'                                                 #[ADD?]# 1.600000 # j  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_heat_viscosity.:.diamagnetic']='?'                                              #[ADD?]# 1.600000 # j  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_inertial.:.diamagnetic']='?'                                                    #[ADD?]# 1.600000 # j  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_ion_neutral_friction.:.diamagnetic']='?'                                        #[ADD?]# 1.600000 # j  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_parallel_viscosity.:.diamagnetic']='?'                                          #[ADD?]# 1.600000 # j  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_perpendicular_viscosity.:.diamagnetic']='?'                                     #[ADD?]# 1.600000 # j  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.j_pfirsch_schlueter.:.diamagnetic']='?'                                           #[ADD?]# 1.600000 # j  [A.m^-2]
cocos_signals['edge_profiles.ggd.:.phi_potential.:.values']='?'                                                      #[ADD?]# 1.600000 # phi  [V]

# EDGE_SOURCES
cocos_signals['edge_sources.source.:.ggd.:.ion.:.state.:.momentum.:.parallel']='?'                               #[ADD?]# 2.818182 # momentum  parallel  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.ion.:.state.:.momentum.:.poloidal']='?'                               #[ADD?]# 2.818182 # momentum  poloidal  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.ion.:.state.:.momentum.:.toroidal']='?'                               #[ADD?]# 2.818182 # momentum  toroidal  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.neutral.:.state.:.momentum.:.parallel']='?'                           #[ADD?]# 2.818182 # momentum  parallel  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.neutral.:.state.:.momentum.:.poloidal']='?'                           #[ADD?]# 2.818182 # momentum  poloidal  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.neutral.:.state.:.momentum.:.toroidal']='?'                           #[ADD?]# 2.818182 # momentum  toroidal  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.ion.:.momentum.:.parallel']='?'                                       #[ADD?]# 2.777778 # momentum  parallel  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.ion.:.momentum.:.poloidal']='?'                                       #[ADD?]# 2.777778 # momentum  poloidal  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.ion.:.momentum.:.toroidal']='?'                                       #[ADD?]# 2.777778 # momentum  toroidal  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.neutral.:.momentum.:.parallel']='?'                                   #[ADD?]# 2.777778 # momentum  parallel  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.neutral.:.momentum.:.poloidal']='?'                                   #[ADD?]# 2.777778 # momentum  poloidal  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.neutral.:.momentum.:.toroidal']='?'                                   #[ADD?]# 2.777778 # momentum  toroidal  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.momentum.:.parallel']='?'                                             #[ADD?]# 2.714286 # momentum  parallel  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.momentum.:.poloidal']='?'                                             #[ADD?]# 2.714286 # momentum  poloidal  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.momentum.:.toroidal']='?'                                             #[ADD?]# 2.714286 # momentum  toroidal  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.ion.:.state.:.momentum.:.diamagnetic']='?'                            #[ADD?]# 1.818182 # momentum  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.neutral.:.state.:.momentum.:.diamagnetic']='?'                        #[ADD?]# 1.818182 # momentum  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.ion.:.momentum.:.diamagnetic']='?'                                    #[ADD?]# 1.777778 # momentum  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.neutral.:.momentum.:.diamagnetic']='?'                                #[ADD?]# 1.777778 # momentum  [kg.m^-1.s^-2]
cocos_signals['edge_sources.source.:.ggd.:.current.:.values']='?'                                                #[ADD?]# 1.714286 # current  [A.m^-2]
cocos_signals['edge_sources.source.:.ggd.:.momentum.:.diamagnetic']='?'                                          #[ADD?]# 1.714286 # momentum  [kg.m^-1.s^-2]

# EDGE_TRANSPORT
cocos_signals['edge_transport.model.:.ggd.:.ion.:.state.:.momentum.flux_limiter.:.parallel']='?'                               #[ADD?]# 2.750000 # momentum  parallel  [-]
cocos_signals['edge_transport.model.:.ggd.:.ion.:.state.:.momentum.flux_limiter.:.poloidal']='?'                               #[ADD?]# 2.750000 # momentum  poloidal  [-]
cocos_signals['edge_transport.model.:.ggd.:.ion.:.state.:.momentum.flux_limiter.:.toroidal']='?'                               #[ADD?]# 2.750000 # momentum  toroidal  [-]
cocos_signals['edge_transport.model.:.ggd.:.neutral.:.state.:.momentum.flux_limiter.:.parallel']='?'                           #[ADD?]# 2.750000 # momentum  parallel  [-]
cocos_signals['edge_transport.model.:.ggd.:.neutral.:.state.:.momentum.flux_limiter.:.poloidal']='?'                           #[ADD?]# 2.750000 # momentum  poloidal  [-]
cocos_signals['edge_transport.model.:.ggd.:.neutral.:.state.:.momentum.flux_limiter.:.toroidal']='?'                           #[ADD?]# 2.750000 # momentum  toroidal  [-]
cocos_signals['edge_transport.model.:.ggd.:.ion.:.momentum.flux_limiter.:.parallel']='?'                                       #[ADD?]# 2.700000 # momentum  parallel  [-]
cocos_signals['edge_transport.model.:.ggd.:.ion.:.momentum.flux_limiter.:.poloidal']='?'                                       #[ADD?]# 2.700000 # momentum  poloidal  [-]
cocos_signals['edge_transport.model.:.ggd.:.ion.:.momentum.flux_limiter.:.toroidal']='?'                                       #[ADD?]# 2.700000 # momentum  toroidal  [-]
cocos_signals['edge_transport.model.:.ggd.:.neutral.:.momentum.flux_limiter.:.parallel']='?'                                   #[ADD?]# 2.700000 # momentum  parallel  [-]
cocos_signals['edge_transport.model.:.ggd.:.neutral.:.momentum.flux_limiter.:.poloidal']='?'                                   #[ADD?]# 2.700000 # momentum  poloidal  [-]
cocos_signals['edge_transport.model.:.ggd.:.neutral.:.momentum.flux_limiter.:.toroidal']='?'                                   #[ADD?]# 2.700000 # momentum  toroidal  [-]
cocos_signals['edge_transport.model.:.ggd.:.momentum.flux_limiter.:.parallel']='?'                                             #[ADD?]# 2.625000 # momentum  parallel  [-]
cocos_signals['edge_transport.model.:.ggd.:.momentum.flux_limiter.:.poloidal']='?'                                             #[ADD?]# 2.625000 # momentum  poloidal  [-]
cocos_signals['edge_transport.model.:.ggd.:.momentum.flux_limiter.:.toroidal']='?'                                             #[ADD?]# 2.625000 # momentum  toroidal  [-]
cocos_signals['edge_transport.model.:.ggd.:.conductivity.:.parallel']='?'                                                      #[ADD?]# 2.000000 # parallel  [ohm^-1.m^-1]
cocos_signals['edge_transport.model.:.ggd.:.conductivity.:.poloidal']='?'                                                      #[ADD?]# 2.000000 # poloidal  [ohm^-1.m^-1]
cocos_signals['edge_transport.model.:.ggd.:.conductivity.:.toroidal']='?'                                                      #[ADD?]# 2.000000 # toroidal  [ohm^-1.m^-1]
cocos_signals['edge_transport.model.:.ggd.:.ion.:.state.:.momentum.flux_limiter.:.diamagnetic']='?'                            #[ADD?]# 1.750000 # momentum  [-]
cocos_signals['edge_transport.model.:.ggd.:.neutral.:.state.:.momentum.flux_limiter.:.diamagnetic']='?'                        #[ADD?]# 1.750000 # momentum  [-]
cocos_signals['edge_transport.model.:.ggd.:.ion.:.momentum.flux_limiter.:.diamagnetic']='?'                                    #[ADD?]# 1.700000 # momentum  [-]
cocos_signals['edge_transport.model.:.ggd.:.neutral.:.momentum.flux_limiter.:.diamagnetic']='?'                                #[ADD?]# 1.700000 # momentum  [-]
cocos_signals['edge_transport.model.:.ggd.:.momentum.flux_limiter.:.diamagnetic']='?'                                          #[ADD?]# 1.625000 # momentum  [-]

# EM_COUPLING

# EQUILIBRIUM
cocos_signals['equilibrium.time_slice.:.global_quantities.magnetic_axis.b_field_tor']='TOR'                                     # 4.000000 # b  b_field  _tor  [T]
cocos_signals['equilibrium.time_slice.:.profiles_2d.:.b_field_tor']='TOR'                                                       # 4.000000 # b  b_field  _tor  [T]
cocos_signals['equilibrium.time_slice.:.ggd.:.b_field_tor.:.values']='TOR'                                                      # 3.142857 # b  b_field  _tor  [T]
cocos_signals['equilibrium.time_slice.:.global_quantities.magnetic_axis.b_tor']='TOR'                                           # 3.000000 # b  _tor  [T]
cocos_signals['equilibrium.time_slice.:.profiles_1d.f_df_dpsi']='F_FPRIME'                                                      # 3.000000 # f  _dpsi  [T^2.m^2/Wb]
cocos_signals['equilibrium.time_slice.:.profiles_1d.j_parallel']='TOR'                                                          # 3.000000 # j  parallel  [A/m^2]
cocos_signals['equilibrium.time_slice.:.profiles_1d.j_tor']='TOR'                                                               # 3.000000 # j  _tor  [A/m^2]
cocos_signals['equilibrium.time_slice.:.profiles_2d.:.b_tor']='TOR'                                                             # 3.000000 # b  _tor  [T]
cocos_signals['equilibrium.time_slice.:.profiles_2d.:.j_parallel']='TOR'                                                        # 3.000000 # j  parallel  [A.m^-2]
cocos_signals['equilibrium.time_slice.:.profiles_2d.:.j_tor']='TOR'                                                             # 3.000000 # j  _tor  [A.m^-2]
cocos_signals['equilibrium.time_slice.:.constraints.b_field_tor_vacuum_r.measured']='TOR'                                       # 2.600000 # b  b_field  [T.m]
cocos_signals['equilibrium.time_slice.:.constraints.b_field_tor_vacuum_r.reconstructed']='TOR'                                  # 2.600000 # b  b_field  [T.m]
cocos_signals['equilibrium.time_slice.:.constraints.q.:.position.phi']='?'                                               #[ADD?]# 2.571429 # q  phi  [rad]
cocos_signals['equilibrium.time_slice.:.ggd.:.j_parallel.:.values']='TOR'                                                       # 2.428571 # j  parallel  [A.m^-2]
cocos_signals['equilibrium.time_slice.:.ggd.:.j_tor.:.values']='TOR'                                                            # 2.428571 # j  _tor  [A.m^-2]
cocos_signals['equilibrium.time_slice.:.boundary.b_flux_pol_norm']='?'                                                   #[ADD?]# 2.000000 # b  [-]
cocos_signals['equilibrium.time_slice.:.boundary.psi']='?'                                                               #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['equilibrium.time_slice.:.boundary_separatrix.psi']='?'                                                    #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['equilibrium.time_slice.:.global_quantities.ip']='TOR'                                                            # 2.000000 # ip  [A]
cocos_signals['equilibrium.time_slice.:.global_quantities.psi_axis']='PSI'                                                      # 2.000000 # psi  [Wb]
cocos_signals['equilibrium.time_slice.:.global_quantities.psi_boundary']='PSI'                                                  # 2.000000 # psi  [Wb]
cocos_signals['equilibrium.time_slice.:.global_quantities.q_95']='Q'                                                            # 2.000000 # q  [-]
cocos_signals['equilibrium.time_slice.:.global_quantities.q_axis']='Q'                                                          # 2.000000 # q  [-]
cocos_signals['equilibrium.time_slice.:.profiles_1d.b_average']='TOR'                                                           # 2.000000 # b  [T]
cocos_signals['equilibrium.time_slice.:.profiles_1d.b_max']='TOR'                                                               # 2.000000 # b  [T]
cocos_signals['equilibrium.time_slice.:.profiles_1d.b_min']='TOR'                                                               # 2.000000 # b  [T]
cocos_signals['equilibrium.time_slice.:.profiles_1d.darea_dpsi']='dPSI'                                                         # 2.000000 # _dpsi  [m^2.Wb^-1]
cocos_signals['equilibrium.time_slice.:.profiles_1d.dpressure_dpsi']='dPSI'                                                     # 2.000000 # _dpsi  [Pa.Wb^-1]
cocos_signals['equilibrium.time_slice.:.profiles_1d.dpsi_drho_tor']='PSI'                                                       # 2.000000 # _tor  [Wb/m]
cocos_signals['equilibrium.time_slice.:.profiles_1d.dvolume_dpsi']='dPSI'                                                       # 2.000000 # _dpsi  [m^3.Wb^-1]
cocos_signals['equilibrium.time_slice.:.profiles_1d.f']='F'                                                                     # 2.000000 # f  [T.m]
cocos_signals['equilibrium.time_slice.:.profiles_1d.phi']='TOR'                                                                 # 2.000000 # phi  [Wb]
cocos_signals['equilibrium.time_slice.:.profiles_1d.psi']='PSI'                                                                 # 2.000000 # psi  [Wb]
cocos_signals['equilibrium.time_slice.:.profiles_1d.q']='Q'                                                                     # 2.000000 # q  [-]
cocos_signals['equilibrium.time_slice.:.profiles_2d.:.phi']='TOR'                                                               # 2.000000 # phi  [Wb]
cocos_signals['equilibrium.time_slice.:.profiles_2d.:.psi']='PSI'                                                               # 2.000000 # psi  [Wb]
cocos_signals['equilibrium.vacuum_toroidal_field.b0']='TOR'                                                                     # 2.000000 # b0  [T]
cocos_signals['equilibrium.time_slice.:.constraints.ip.measured']='TOR'                                                         # 1.800000 # ip  [A]
cocos_signals['equilibrium.time_slice.:.constraints.ip.reconstructed']='TOR'                                                    # 1.800000 # ip  [A]
cocos_signals['equilibrium.time_slice.:.global_quantities.q_min.value']='Q'                                                     # 1.800000 # q  [-]
cocos_signals['equilibrium.time_slice.:.ggd.:.phi.:.values']='TOR'                                                              # 1.714286 # phi  [Wb]
cocos_signals['equilibrium.time_slice.:.ggd.:.psi.:.values']='PSI'                                                              # 1.714286 # psi  [Wb]
cocos_signals['equilibrium.time_slice.:.constraints.pf_current.:.measured']='?'                                          #[ADD?]# 1.666667 # current  [A]
cocos_signals['equilibrium.time_slice.:.constraints.pf_current.:.reconstructed']='?'                                     #[ADD?]# 1.666667 # current  [A]
cocos_signals['equilibrium.time_slice.:.constraints.q.:.measured']='Q'                                                          # 1.666667 # q  [-]
cocos_signals['equilibrium.time_slice.:.constraints.q.:.reconstructed']='Q'                                                     # 1.666667 # q  [-]

# GAS_INJECTION
cocos_signals['gas_injection.pipe.:.exit_position.phi']='TOR'                                       # 2.000000 # phi  [rad]
cocos_signals['gas_injection.pipe.:.second_point.phi']='?'                                   #[ADD?]# 2.000000 # phi  [rad]

# IC_ANTENNAS
cocos_signals['ic_antennas.antenna.:.module.:.current.:.position.phi']='?'                                    #[ADD?]# 2.625000 # current  phi  [rad]
cocos_signals['ic_antennas.antenna.:.module.:.pressure.:.position.phi']='?'                                   #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['ic_antennas.antenna.:.module.:.strap.:.outline.phi']='?'                                       #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['ic_antennas.antenna.:.module.:.voltage.:.position.phi']='?'                                    #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['ic_antennas.antenna.:.module.:.strap.:.current.data']='?'                                      #[ADD?]# 1.875000 # current  [A]
cocos_signals['ic_antennas.antenna.:.module.:.current.:.amplitude.data']='?'                                  #[ADD?]# 1.625000 # current  [A]
cocos_signals['ic_antennas.antenna.:.module.:.current.:.phase.data']='?'                                      #[ADD?]# 1.625000 # current  [rad]
cocos_signals['ic_antennas.antenna.:.surface_current.:.spectrum']='?'                                         #[ADD?]# 1.600000 # current  [A]

# INFO

# INTERFEROMETER
cocos_signals['interferometer.channel.:.line_of_sight.first_point.phi']='TOR'                            # 2.000000 # phi  [rad]
cocos_signals['interferometer.channel.:.line_of_sight.second_point.phi']='TOR'                           # 2.000000 # phi  [rad]
cocos_signals['interferometer.channel.:.line_of_sight.third_point.phi']='TOR'                            # 2.000000 # phi  [rad]

# IRON_CORE
cocos_signals['iron_core.segment.:.b_field']='?'                                           #[ADD?]# 3.000000 # b  b_field  [T]

# LH_ANTENNAS
cocos_signals['lh_antennas.antenna.:.position.phi.data']='?'                              #[ADD?]# 1.800000 # phi  [rad]

# MAGNETICS
cocos_signals['magnetics.bpol_probe.:.poloidal_angle']='?'              #[ADD?]# 2.000000 # poloidal  [rad]
cocos_signals['magnetics.bpol_probe.:.position.phi']='TOR'                     # 2.000000 # phi  [rad]
cocos_signals['magnetics.bpol_probe.:.toroidal_angle']='?'              #[ADD?]# 2.000000 # toroidal  [rad]
cocos_signals['magnetics.flux_loop.:.position.:.phi']='TOR'                    # 2.000000 # phi  [rad]
cocos_signals['magnetics.method.:.ip.data']='TOR'                              # 1.750000 # ip  [A]

# MHD
cocos_signals['mhd.ggd.:.b_field_tor.:.values']='?'                                              #[ADD?]# 2.800000 # b  b_field  _tor  [T]
cocos_signals['mhd.ggd.:.j_tor.:.values']='?'                                                    #[ADD?]# 2.200000 # j  _tor  [A.m^-2]
cocos_signals['mhd.ggd.:.velocity_parallel.:.values']='?'                                        #[ADD?]# 2.200000 # velocity  parallel  [m.s^-1]
cocos_signals['mhd.ggd.:.velocity_tor.:.values']='?'                                             #[ADD?]# 2.200000 # velocity  _tor  [m.s^-1]
cocos_signals['mhd.ggd.:.a_field_tor.:.values']='?'                                              #[ADD?]# 1.600000 # _tor  [T.m]
cocos_signals['mhd.ggd.:.phi_potential.:.values']='?'                                            #[ADD?]# 1.600000 # phi  [V]
cocos_signals['mhd.ggd.:.psi.:.values']='?'                                                      #[ADD?]# 1.600000 # psi  [Wb]

# MHD_LINEAR
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate1.imaginary']='?'            #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate1.real']='?'                 #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate2.imaginary']='?'            #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate2.real']='?'                 #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate3.imaginary']='?'            #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.b_field_perturbed.coordinate3.real']='?'                 #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate1.imaginary']='?'            #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate1.real']='?'                 #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate2.imaginary']='?'            #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate2.real']='?'                 #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate3.imaginary']='?'            #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.b_field_perturbed.coordinate3.real']='?'                 #[ADD?]# 2.875000 # toroidal  b  b_field  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.displacement_parallel.imaginary']='?'                    #[ADD?]# 2.285714 # toroidal  parallel  [m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.displacement_parallel.real']='?'                         #[ADD?]# 2.285714 # toroidal  parallel  [m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate1.imaginary']='?'           #[ADD?]# 2.125000 # toroidal  velocity  [m/s]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate1.real']='?'                #[ADD?]# 2.125000 # toroidal  velocity  [m/s]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate2.imaginary']='?'           #[ADD?]# 2.125000 # toroidal  velocity  [m/s]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate2.real']='?'                #[ADD?]# 2.125000 # toroidal  velocity  [m/s]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate3.imaginary']='?'           #[ADD?]# 2.125000 # toroidal  velocity  [m/s]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.velocity_perturbed.coordinate3.real']='?'                #[ADD?]# 2.125000 # toroidal  velocity  [m/s]
cocos_signals['mhd_linear.vacuum_toroidal_field.b0']='TOR'                                                                    # 2.000000 # b0  [T]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.frequency']='?'                                                 #[ADD?]# 1.600000 # toroidal  [Hz]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.growthrate']='?'                                                #[ADD?]# 1.600000 # toroidal  [Hz]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.coordinate_system.jacobian']='?'                         #[ADD?]# 1.428571 # toroidal  [mixed]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.coordinate_system.tensor_contravariant']='?'             #[ADD?]# 1.428571 # toroidal  [mixed]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.coordinate_system.tensor_covariant']='?'                 #[ADD?]# 1.428571 # toroidal  [mixed]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.displacement_perpendicular.imaginary']='?'               #[ADD?]# 1.428571 # toroidal  [m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.displacement_perpendicular.real']='?'                    #[ADD?]# 1.428571 # toroidal  [m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.grid.dim1']='?'                                          #[ADD?]# 1.428571 # toroidal  [mixed]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.grid.dim2']='?'                                          #[ADD?]# 1.428571 # toroidal  [mixed]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.grid.volume_element']='?'                                #[ADD?]# 1.428571 # toroidal  [m^3]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.mass_density_perturbed.imaginary']='?'                   #[ADD?]# 1.428571 # toroidal  [kg.m^-3]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.mass_density_perturbed.real']='?'                        #[ADD?]# 1.428571 # toroidal  [kg.m^-3]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.pressure_perturbed.imaginary']='?'                       #[ADD?]# 1.428571 # toroidal  [Pa]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.pressure_perturbed.real']='?'                            #[ADD?]# 1.428571 # toroidal  [Pa]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.temperature_perturbed.imaginary']='?'                    #[ADD?]# 1.428571 # toroidal  [eV]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.temperature_perturbed.real']='?'                         #[ADD?]# 1.428571 # toroidal  [eV]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.coordinate_system.jacobian']='?'                         #[ADD?]# 1.428571 # toroidal  [mixed]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.coordinate_system.tensor_contravariant']='?'             #[ADD?]# 1.428571 # toroidal  [mixed]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.coordinate_system.tensor_covariant']='?'                 #[ADD?]# 1.428571 # toroidal  [mixed]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.grid.dim1']='?'                                          #[ADD?]# 1.428571 # toroidal  [mixed]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.grid.dim2']='?'                                          #[ADD?]# 1.428571 # toroidal  [mixed]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.grid.volume_element']='?'                                #[ADD?]# 1.428571 # toroidal  [m^3]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate1.imaginary']='?'            #[ADD?]# 1.375000 # toroidal  [T.m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate1.real']='?'                 #[ADD?]# 1.375000 # toroidal  [T.m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate2.imaginary']='?'            #[ADD?]# 1.375000 # toroidal  [T.m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate2.real']='?'                 #[ADD?]# 1.375000 # toroidal  [T.m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate3.imaginary']='?'            #[ADD?]# 1.375000 # toroidal  [T.m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.plasma.a_field_perturbed.coordinate3.real']='?'                 #[ADD?]# 1.375000 # toroidal  [T.m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate1.imaginary']='?'            #[ADD?]# 1.375000 # toroidal  [T.m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate1.real']='?'                 #[ADD?]# 1.375000 # toroidal  [T.m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate2.imaginary']='?'            #[ADD?]# 1.375000 # toroidal  [T.m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate2.real']='?'                 #[ADD?]# 1.375000 # toroidal  [T.m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate3.imaginary']='?'            #[ADD?]# 1.375000 # toroidal  [T.m]
cocos_signals['mhd_linear.time_slice.:.toroidal_mode.:.vacuum.a_field_perturbed.coordinate3.real']='?'                 #[ADD?]# 1.375000 # toroidal  [T.m]

# MSE
cocos_signals['mse.channel.:.active_spatial_resolution.:.centre.phi']='?'                       #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['mse.channel.:.active_spatial_resolution.:.width.phi']='?'                        #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['mse.channel.:.aperture.:.centre.phi']='?'                                        #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['mse.channel.:.detector.centre.phi']='?'                                          #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['mse.channel.:.line_of_sight.first_point.phi']='?'                                #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['mse.channel.:.line_of_sight.second_point.phi']='?'                               #[ADD?]# 2.000000 # phi  [rad]

# NBI
cocos_signals['nbi.unit.:.beamlets_group.:.beamlets.positions.phi']='?'                              #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['nbi.unit.:.beamlets_group.:.position.phi']='?'                                        #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['nbi.unit.:.beamlets_group.:.tilting.:.delta_position.phi']='?'                        #[ADD?]# 2.000000 # phi  [rad]

# NEUTRON_DIAGNOSTIC
cocos_signals['neutron_diagnostic.detectors.:.b_field_sensor.amplitude.data']='?'                    #[ADD?]# 2.200000 # b  b_field  [V]
cocos_signals['neutron_diagnostic.detectors.:.b_field_sensor.frequency.data']='?'                    #[ADD?]# 2.200000 # b  b_field  [Hz]
cocos_signals['neutron_diagnostic.detectors.:.aperture.:.centre.phi']='?'                            #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['neutron_diagnostic.detectors.:.detector.centre.phi']='?'                              #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['neutron_diagnostic.detectors.:.position.phi']='?'                                     #[ADD?]# 2.000000 # phi  [rad]

# NTMS
cocos_signals['ntms.vacuum_toroidal_field.b0']='TOR'                                             # 2.000000 # b0  [T]
cocos_signals['ntms.time_slice.:.mode.:.detailed_evolution.torque.:.value']='?'           #[ADD?]# 1.750000 # torque  [kg.m^2.s^-2]
cocos_signals['ntms.time_slice.:.mode.:.torque.:.value']='?'                              #[ADD?]# 1.714286 # torque  [kg.m^2.s^-2]

# PELLETS
cocos_signals['pellets.time_slice.:.pellet.:.path_geometry.first_point.phi']='?'              #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['pellets.time_slice.:.pellet.:.path_geometry.second_point.phi']='?'             #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['pellets.time_slice.:.pellet.:.path_profiles.position.phi']='?'                 #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['pellets.time_slice.:.pellet.:.path_profiles.psi']='?'                          #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['pellets.time_slice.:.pellet.:.path_profiles.velocity']='?'                     #[ADD?]# 2.000000 # velocity  [m.s^-1]
cocos_signals['pellets.time_slice.:.pellet.:.velocity_initial']='?'                           #[ADD?]# 2.000000 # velocity  [m.s^-1]

# PF_ACTIVE
cocos_signals['pf_active.coil.:.current_limit_max']='?'                                           #[ADD?]# 2.000000 # current  [A]
cocos_signals['pf_active.supply.:.current_limit_max']='?'                                         #[ADD?]# 2.000000 # current  [A]
cocos_signals['pf_active.supply.:.current_limit_min']='?'                                         #[ADD?]# 2.000000 # current  [A]
cocos_signals['pf_active.supply.:.current_limiter_gain']='?'                                      #[ADD?]# 2.000000 # current  [V]
cocos_signals['pf_active.circuit.:.current.data']='?'                                             #[ADD?]# 1.750000 # current  [A]
cocos_signals['pf_active.coil.:.current.data']='?'                                                #[ADD?]# 1.750000 # current  [A]
cocos_signals['pf_active.supply.:.current.data']='?'                                              #[ADD?]# 1.750000 # current  [A]

# PF_PASSIVE
cocos_signals['pf_passive.loop.:.current']='?'                                                     #[ADD?]# 2.000000 # current  [A]

# POLARIMETER
cocos_signals['polarimeter.channel.:.line_of_sight.first_point.phi']='?'            #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['polarimeter.channel.:.line_of_sight.second_point.phi']='?'           #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['polarimeter.channel.:.line_of_sight.third_point.phi']='?'            #[ADD?]# 2.000000 # phi  [rad]

# PULSE_SCHEDULE
cocos_signals['pulse_schedule.tf.b_field_tor_vacuum_r.reference.data']='?'                             #[ADD?]# 2.000000 # b  b_field  [mixed]
cocos_signals['pulse_schedule.ec.antenna.:.launching_angle_pol.reference.data']='?'                    #[ADD?]# 1.666667 # _pol  [mixed]
cocos_signals['pulse_schedule.ec.antenna.:.launching_angle_tor.reference.data']='?'                    #[ADD?]# 1.666667 # _tor  [mixed]
cocos_signals['pulse_schedule.lh.antenna.:.n_parallel.reference.data']='?'                             #[ADD?]# 1.666667 # parallel  [mixed]

# RADIATION
cocos_signals['radiation.process.:.profiles_1d.:.grid.psi']='?'                                          #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['radiation.vacuum_toroidal_field.b0']='TOR'                                                       # 2.000000 # b0  [T]

# REFLECTOMETER_PROFILE
cocos_signals['reflectometer_profile.channel.:.line_of_sight_detection.first_point.phi']='?'            #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['reflectometer_profile.channel.:.line_of_sight_detection.second_point.phi']='?'           #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['reflectometer_profile.channel.:.line_of_sight_emission.first_point.phi']='?'             #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['reflectometer_profile.channel.:.line_of_sight_emission.second_point.phi']='?'            #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['reflectometer_profile.channel.:.position.phi.data']='?'                                  #[ADD?]# 1.800000 # phi  [rad]

# SAWTEETH
cocos_signals['sawteeth.profiles_1d.:.e_field_parallel']='?'                       #[ADD?]# 3.000000 # e_field  parallel  [V.m^-1]
cocos_signals['sawteeth.profiles_1d.:.j_tor']='?'                                  #[ADD?]# 3.000000 # j  _tor  [A/m^2]
cocos_signals['sawteeth.profiles_1d.:.momentum_tor']='?'                           #[ADD?]# 3.000000 # momentum  _tor  [kg.m/s]
cocos_signals['sawteeth.profiles_1d.:.grid.psi']='?'                               #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['sawteeth.profiles_1d.:.j_bootstrap']='?'                            #[ADD?]# 2.000000 # j  [A/m^2]
cocos_signals['sawteeth.profiles_1d.:.j_non_inductive']='?'                        #[ADD?]# 2.000000 # j  [A/m^2]
cocos_signals['sawteeth.profiles_1d.:.j_ohmic']='?'                                #[ADD?]# 2.000000 # j  [A/m^2]
cocos_signals['sawteeth.profiles_1d.:.j_total']='?'                                #[ADD?]# 2.000000 # j  [A/m^2]
cocos_signals['sawteeth.profiles_1d.:.p_e_fast_parallel']='?'                      #[ADD?]# 2.000000 # parallel  [Pa]
cocos_signals['sawteeth.profiles_1d.:.p_i_total_fast_parallel']='?'                #[ADD?]# 2.000000 # parallel  [Pa]
cocos_signals['sawteeth.profiles_1d.:.phi']='?'                                    #[ADD?]# 2.000000 # phi  [Wb]
cocos_signals['sawteeth.profiles_1d.:.psi_star_post_crash']='?'                    #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['sawteeth.profiles_1d.:.psi_star_pre_crash']='?'                     #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['sawteeth.profiles_1d.:.q']='?'                                      #[ADD?]# 2.000000 # q  [-]
cocos_signals['sawteeth.vacuum_toroidal_field.b0']='TOR'                                  # 2.000000 # b0  [T]

# SDN

# SOFT_X_RAYS
cocos_signals['soft_x_rays.channel.:.aperture.:.centre.phi']='?'                        #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['soft_x_rays.channel.:.detector.centre.phi']='?'                          #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['soft_x_rays.channel.:.line_of_sight.first_point.phi']='?'                #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['soft_x_rays.channel.:.line_of_sight.second_point.phi']='?'               #[ADD?]# 2.000000 # phi  [rad]

# SPECTROMETER_VISIBLE
cocos_signals['spectrometer_visible.channel.:.active_spatial_resolution.:.centre.phi']='?'                             #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['spectrometer_visible.channel.:.active_spatial_resolution.:.width.phi']='?'                              #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['spectrometer_visible.channel.:.aperture.:.centre.phi']='?'                                              #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['spectrometer_visible.channel.:.detector.centre.phi']='?'                                                #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['spectrometer_visible.channel.:.detector_image.outline.phi']='?'                                         #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['spectrometer_visible.channel.:.fibre_image.outline.phi']='?'                                            #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['spectrometer_visible.channel.:.light_collection_efficiencies.positions.phi']='?'                        #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['spectrometer_visible.channel.:.line_of_sight.first_point.phi']='?'                                      #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['spectrometer_visible.channel.:.line_of_sight.second_point.phi']='?'                                     #[ADD?]# 2.000000 # phi  [rad]

# SUMMARY
cocos_signals['summary.local.itb.momentum_tor.value']='?'                                                                     #[ADD?]# 2.500000 # momentum  _tor  [kg.m.s^-1]
cocos_signals['summary.local.magnetic_axis.b_field.value']='?'                                                                #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.local.magnetic_axis.momentum_tor.value']='?'                                                           #[ADD?]# 2.500000 # momentum  _tor  [kg.m.s^-1]
cocos_signals['summary.local.pedestal.momentum_tor.value']='?'                                                                #[ADD?]# 2.500000 # momentum  _tor  [kg.m.s^-1]
cocos_signals['summary.local.separatrix.momentum_tor.value']='?'                                                              #[ADD?]# 2.500000 # momentum  _tor  [kg.m.s^-1]
cocos_signals['summary.pedestal_fits.linear.b_field_pedestal_top_hfs.value']='?'                                              #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.linear.b_field_pedestal_top_lfs.value']='?'                                              #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.linear.b_field_pol_pedestal_top_average.value']='?'                                      #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.linear.b_field_pol_pedestal_top_hfs.value']='?'                                          #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.linear.b_field_pol_pedestal_top_lfs.value']='?'                                          #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.linear.b_field_tor_pedestal_top_hfs.value']='?'                                          #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.linear.b_field_tor_pedestal_top_lfs.value']='?'                                          #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.mtanh.b_field_pedestal_top_hfs.value']='?'                                               #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.mtanh.b_field_pedestal_top_lfs.value']='?'                                               #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.mtanh.b_field_pol_pedestal_top_average.value']='?'                                       #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.mtanh.b_field_pol_pedestal_top_hfs.value']='?'                                           #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.mtanh.b_field_pol_pedestal_top_lfs.value']='?'                                           #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.mtanh.b_field_tor_pedestal_top_hfs.value']='?'                                           #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.pedestal_fits.mtanh.b_field_tor_pedestal_top_lfs.value']='?'                                           #[ADD?]# 2.500000 # b  b_field  [T]
cocos_signals['summary.global_quantities.energy_b_field_pol.value']='?'                                                       #[ADD?]# 2.333333 # b_field  _pol  [J]
cocos_signals['summary.local.itb.velocity_tor.argon.value']='?'                                                               #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.beryllium.value']='?'                                                           #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.carbon.value']='?'                                                              #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.deuterium.value']='?'                                                           #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.helium_3.value']='?'                                                            #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.helium_4.value']='?'                                                            #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.hydrogen.value']='?'                                                            #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.lithium.value']='?'                                                             #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.neon.value']='?'                                                                #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.nitrogen.value']='?'                                                            #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.oxygen.value']='?'                                                              #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.tritium.value']='?'                                                             #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.tungsten.value']='?'                                                            #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.velocity_tor.xenon.value']='?'                                                               #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.argon.value']='?'                                                     #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.beryllium.value']='?'                                                 #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.carbon.value']='?'                                                    #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.deuterium.value']='?'                                                 #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.helium_3.value']='?'                                                  #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.helium_4.value']='?'                                                  #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.hydrogen.value']='?'                                                  #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.lithium.value']='?'                                                   #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.neon.value']='?'                                                      #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.nitrogen.value']='?'                                                  #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.oxygen.value']='?'                                                    #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.tritium.value']='?'                                                   #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.tungsten.value']='?'                                                  #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.magnetic_axis.velocity_tor.xenon.value']='?'                                                     #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.argon.value']='?'                                                          #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.beryllium.value']='?'                                                      #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.carbon.value']='?'                                                         #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.deuterium.value']='?'                                                      #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.helium_3.value']='?'                                                       #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.helium_4.value']='?'                                                       #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.hydrogen.value']='?'                                                       #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.lithium.value']='?'                                                        #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.neon.value']='?'                                                           #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.nitrogen.value']='?'                                                       #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.oxygen.value']='?'                                                         #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.tritium.value']='?'                                                        #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.tungsten.value']='?'                                                       #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.pedestal.velocity_tor.xenon.value']='?'                                                          #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.argon.value']='?'                                                        #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.beryllium.value']='?'                                                    #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.carbon.value']='?'                                                       #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.deuterium.value']='?'                                                    #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.helium_3.value']='?'                                                     #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.helium_4.value']='?'                                                     #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.hydrogen.value']='?'                                                     #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.lithium.value']='?'                                                      #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.neon.value']='?'                                                         #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.nitrogen.value']='?'                                                     #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.oxygen.value']='?'                                                       #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.tritium.value']='?'                                                      #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.tungsten.value']='?'                                                     #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.separatrix.velocity_tor.xenon.value']='?'                                                        #[ADD?]# 2.200000 # velocity  _tor  [as_parent_level_2]
cocos_signals['summary.local.itb.position.psi']='?'                                                                           #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['summary.local.magnetic_axis.position.psi']='?'                                                                 #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['summary.local.pedestal.position.psi']='?'                                                                      #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['summary.local.separatrix.position.psi']='?'                                                                    #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['summary.heating_current_drive.nbi.:.position.phi.value']='?'                                                   #[ADD?]# 1.833333 # phi  [rad]
cocos_signals['summary.heating_current_drive.ec.:.angle_pol.value']='?'                                                       #[ADD?]# 1.800000 # _pol  [rad]
cocos_signals['summary.heating_current_drive.ec.:.angle_tor.value']='?'                                                       #[ADD?]# 1.800000 # _tor  [rad]
cocos_signals['summary.heating_current_drive.ec.:.current.value']='?'                                                         #[ADD?]# 1.800000 # current  [A]
cocos_signals['summary.heating_current_drive.ic.:.current.value']='?'                                                         #[ADD?]# 1.800000 # current  [A]
cocos_signals['summary.heating_current_drive.lh.:.current.value']='?'                                                         #[ADD?]# 1.800000 # current  [A]
cocos_signals['summary.heating_current_drive.lh.:.n_parallel.value']='?'                                                      #[ADD?]# 1.800000 # parallel  [-]
cocos_signals['summary.heating_current_drive.nbi.:.current.value']='?'                                                        #[ADD?]# 1.800000 # current  [A]
cocos_signals['summary.local.itb.q.value']='?'                                                                                #[ADD?]# 1.750000 # q  [-]
cocos_signals['summary.local.magnetic_axis.q.value']='?'                                                                      #[ADD?]# 1.750000 # q  [-]
cocos_signals['summary.local.pedestal.q.value']='?'                                                                           #[ADD?]# 1.750000 # q  [-]
cocos_signals['summary.local.separatrix.q.value']='?'                                                                         #[ADD?]# 1.750000 # q  [-]
cocos_signals['summary.fusion.current.value']='TOR'                                                                                  # 1.666667 # current  [A]
cocos_signals['summary.global_quantities.b0.value']='TOR'                                                                            # 1.666667 # b0  [T]
cocos_signals['summary.global_quantities.current_alignment.value']='?'                                                        #[ADD?]# 1.666667 # current  [A]
cocos_signals['summary.global_quantities.current_bootstrap.value']='?'                                                        #[ADD?]# 1.666667 # current  [A]
cocos_signals['summary.global_quantities.current_non_inductive.value']='?'                                                    #[ADD?]# 1.666667 # current  [A]
cocos_signals['summary.global_quantities.current_ohm.value']='?'                                                              #[ADD?]# 1.666667 # current  [A]
cocos_signals['summary.global_quantities.energy_fast_parallel.value']='?'                                                     #[ADD?]# 1.666667 # parallel  [J]
cocos_signals['summary.global_quantities.ip.value']='TOR'                                                                            # 1.666667 # ip  [A]
cocos_signals['summary.global_quantities.q_95.value']='?'                                                                     #[ADD?]# 1.666667 # q  [-]
cocos_signals['summary.global_quantities.v_loop.value']='TOR'                                                                        # 1.666667 # v  [V]
cocos_signals['summary.pedestal_fits.mtanh.stability.bootstrap_current_hager.alpha_critical.value']='?'                       #[ADD?]# 1.666667 # current  [-]
cocos_signals['summary.pedestal_fits.mtanh.stability.bootstrap_current_hager.t_e_pedestal_top_critical.value']='?'            #[ADD?]# 1.666667 # current  [eV]
cocos_signals['summary.pedestal_fits.mtanh.stability.bootstrap_current_sauter.alpha_critical.value']='?'                      #[ADD?]# 1.666667 # current  [-]
cocos_signals['summary.pedestal_fits.mtanh.stability.bootstrap_current_sauter.t_e_pedestal_top_critical.value']='?'           #[ADD?]# 1.666667 # current  [eV]
cocos_signals['summary.runaways.current.value']='?'                                                                           #[ADD?]# 1.666667 # current  [A]

# TEMPORARY

# TF
cocos_signals['tf.field_map.:.b_field_tor.:.values']='?'                                              #[ADD?]# 2.800000 # b  b_field  _tor  [T]
cocos_signals['tf.coil.:.conductor.:.elements.centres.phi']='?'                                       #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['tf.coil.:.conductor.:.elements.end_points.phi']='?'                                    #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['tf.coil.:.conductor.:.elements.intermediate_points.phi']='?'                           #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['tf.coil.:.conductor.:.elements.start_points.phi']='?'                                  #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['tf.coil.:.conductor.:.current.data']='?'                                               #[ADD?]# 1.833333 # current  [A]
cocos_signals['tf.coil.:.current.data']='?'                                                           #[ADD?]# 1.750000 # current  [A]
cocos_signals['tf.field_map.:.a_field_tor.:.values']='?'                                              #[ADD?]# 1.600000 # _tor  [T.m]

# THOMSON_SCATTERING
cocos_signals['thomson_scattering.channel.:.position.phi']='TOR'                # 2.000000 # phi  [rad]

# TRANSPORT_SOLVER_NUMERICS
cocos_signals['transport_solver_numerics.derivatives_1d.:.electrons.d2_drho_tor_norm2.velocity_pol']='?'                                   #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.electrons.d2_drho_tor_norm2.velocity_tor']='?'                                   #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.electrons.d_drho_tor_norm.velocity_pol']='?'                                     #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.electrons.d_drho_tor_norm.velocity_tor']='?'                                     #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.electrons.d_dt.velocity_pol']='?'                                                #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.electrons.d_dt.velocity_tor']='?'                                                #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.d2_drho_tor_norm2.velocity_pol']='?'                                       #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.d2_drho_tor_norm2.velocity_tor']='?'                                       #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.d_drho_tor_norm.velocity_pol']='?'                                         #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.d_drho_tor_norm.velocity_tor']='?'                                         #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.d_dt.velocity_pol']='?'                                                    #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.d_dt.velocity_tor']='?'                                                    #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.state.:.d2_drho_tor_norm2.velocity_pol']='?'                               #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.state.:.d2_drho_tor_norm2.velocity_tor']='?'                               #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.state.:.d_drho_tor_norm.velocity_pol']='?'                                 #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.state.:.d_drho_tor_norm.velocity_tor']='?'                                 #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.state.:.d_dt.velocity_pol']='?'                                            #[ADD?]# 3.000000 # velocity  _pol  [m.s^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.ion.:.state.:.d_dt.velocity_tor']='?'                                            #[ADD?]# 3.000000 # velocity  _tor  [m.s^-1]
cocos_signals['transport_solver_numerics.boundary_conditions_1d.:.momentum_tor.value']='?'                                                 #[ADD?]# 2.500000 # momentum  _tor  [mixed]
cocos_signals['transport_solver_numerics.derivatives_1d.:.dpsi_drho_tor']='?'                                                              #[ADD?]# 2.000000 # _tor  [Wb.m^-1]
cocos_signals['transport_solver_numerics.derivatives_1d.:.grid.psi']='?'                                                                   #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['transport_solver_numerics.solver_1d.:.grid.psi']='?'                                                                        #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['transport_solver_numerics.vacuum_toroidal_field.b0']='TOR'                                                                         # 2.000000 # b0  [T]
cocos_signals['transport_solver_numerics.boundary_conditions_1d.:.current.value']='?'                                                      #[ADD?]# 1.750000 # current  [mixed]
cocos_signals['transport_solver_numerics.boundary_conditions_ggd.:.current.:.values']='?'                                                  #[ADD?]# 1.600000 # current  [mixed]

# TURBULENCE

# WALL
cocos_signals['wall.description_2d.:.vessel.unit.:.element.:.j_tor.data']='?'                                       #[ADD?]# 2.777778 # j  _tor  [A]

# WAVES
cocos_signals['waves.coherent_wave.:.profiles_1d.:.e_field_n_tor.:.parallel.amplitude']='?'                              #[ADD?]# 3.125000 # e_field  _tor  parallel  [V.m^-1]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.e_field_n_tor.:.parallel.phase']='?'                                  #[ADD?]# 3.125000 # e_field  _tor  parallel  [V.m^-1]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.e_field_n_tor.:.parallel.amplitude']='?'                              #[ADD?]# 3.125000 # e_field  _tor  parallel  [V.m^-1]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.e_field_n_tor.:.parallel.phase']='?'                                  #[ADD?]# 3.125000 # e_field  _tor  parallel  [V.m^-1]
cocos_signals['waves.coherent_wave.:.full_wave.:.b_field.parallel.:.values']='?'                                         #[ADD?]# 3.000000 # b  b_field  parallel  [V.m^-1]
cocos_signals['waves.coherent_wave.:.global_quantities.:.current_tor']='?'                                               #[ADD?]# 3.000000 # current  _tor  [A]
cocos_signals['waves.coherent_wave.:.global_quantities.:.current_tor_n_tor']='?'                                         #[ADD?]# 3.000000 # current  _tor  [A]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.current_parallel_density_n_tor']='?'                                  #[ADD?]# 3.000000 # current  _tor  [A.m^-2]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.current_tor_inside_n_tor']='?'                                        #[ADD?]# 3.000000 # current  _tor  [A]
cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.e_field.parallel.imaginary']='?'                              #[ADD?]# 2.666667 # e_field  parallel  [V.m^-1]
cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.e_field.parallel.real']='?'                                   #[ADD?]# 2.666667 # e_field  parallel  [V.m^-1]
cocos_signals['waves.coherent_wave.:.full_wave.:.e_field.parallel.:.values']='?'                                         #[ADD?]# 2.375000 # e_field  parallel  [V.m^-1]
cocos_signals['waves.coherent_wave.:.full_wave.:.b_field.bi_normal.:.values']='?'                                        #[ADD?]# 2.250000 # b  b_field  [V.m^-1]
cocos_signals['waves.coherent_wave.:.full_wave.:.b_field.normal.:.values']='?'                                           #[ADD?]# 2.250000 # b  b_field  [V.m^-1]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.e_field_n_tor.:.minus.amplitude']='?'                                 #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.e_field_n_tor.:.minus.phase']='?'                                     #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.e_field_n_tor.:.plus.amplitude']='?'                                  #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.e_field_n_tor.:.plus.phase']='?'                                      #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.e_field_n_tor.:.minus.amplitude']='?'                                 #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.e_field_n_tor.:.minus.phase']='?'                                     #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.e_field_n_tor.:.plus.amplitude']='?'                                  #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.e_field_n_tor.:.plus.phase']='?'                                      #[ADD?]# 2.250000 # e_field  _tor  [V.m^-1]
cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.position.phi']='?'                                            #[ADD?]# 2.000000 # phi  [rad]
cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.position.psi']='?'                                            #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.power_flow_norm.parallel']='?'                                #[ADD?]# 2.000000 # parallel  [-]
cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.wave_vector.k_tor']='?'                                       #[ADD?]# 2.000000 # _tor  [m^-1]
cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.wave_vector.n_parallel']='?'                                  #[ADD?]# 2.000000 # parallel  [-]
cocos_signals['waves.coherent_wave.:.global_quantities.:.electrons.power_fast_n_tor']='?'                                #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.global_quantities.:.electrons.power_thermal_n_tor']='?'                             #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.global_quantities.:.ion.:.power_fast_n_tor']='?'                                    #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.global_quantities.:.ion.:.power_thermal_n_tor']='?'                                 #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.global_quantities.:.ion.:.state.:.power_fast_n_tor']='?'                            #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.global_quantities.:.ion.:.state.:.power_thermal_n_tor']='?'                         #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.global_quantities.:.power_n_tor']='?'                                               #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.current_parallel_density']='?'                                        #[ADD?]# 2.000000 # current  [A.m^-2]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.current_tor_inside']='?'                                              #[ADD?]# 2.000000 # current  [A]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.electrons.power_density_fast_n_tor']='?'                              #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.electrons.power_density_thermal_n_tor']='?'                           #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.electrons.power_inside_fast_n_tor']='?'                               #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.electrons.power_inside_thermal_n_tor']='?'                            #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.grid.psi']='?'                                                        #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.power_density_fast_n_tor']='?'                                  #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.power_density_thermal_n_tor']='?'                               #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.power_inside_fast_n_tor']='?'                                   #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.power_inside_thermal_n_tor']='?'                                #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.state.:.power_density_fast_n_tor']='?'                          #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.state.:.power_density_thermal_n_tor']='?'                       #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.state.:.power_inside_fast_n_tor']='?'                           #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.ion.:.state.:.power_inside_thermal_n_tor']='?'                        #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.power_density_n_tor']='?'                                             #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_1d.:.power_inside_n_tor']='?'                                              #[ADD?]# 2.000000 # _tor  [W]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.electrons.power_density_fast_n_tor']='?'                              #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.electrons.power_density_thermal_n_tor']='?'                           #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.grid.psi']='?'                                                        #[ADD?]# 2.000000 # psi  [Wb]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.ion.:.power_density_fast_n_tor']='?'                                  #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.ion.:.power_density_thermal_n_tor']='?'                               #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.ion.:.state.:.power_density_fast_n_tor']='?'                          #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.ion.:.state.:.power_density_thermal_n_tor']='?'                       #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.coherent_wave.:.profiles_2d.:.power_density_n_tor']='?'                                             #[ADD?]# 2.000000 # _tor  [W.m^-3]
cocos_signals['waves.vacuum_toroidal_field.b0']='TOR'                                                                           # 2.000000 # b0  [T]
cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.e_field.minus.imaginary']='?'                                 #[ADD?]# 1.777778 # e_field  [V.m^-1]
cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.e_field.minus.real']='?'                                      #[ADD?]# 1.777778 # e_field  [V.m^-1]
cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.e_field.plus.imaginary']='?'                                  #[ADD?]# 1.777778 # e_field  [V.m^-1]
cocos_signals['waves.coherent_wave.:.beam_tracing.:.beam.:.e_field.plus.real']='?'                                       #[ADD?]# 1.777778 # e_field  [V.m^-1]
cocos_signals['waves.coherent_wave.:.full_wave.:.e_field.bi_normal.:.values']='?'                                        #[ADD?]# 1.625000 # e_field  [V.m^-1]
cocos_signals['waves.coherent_wave.:.full_wave.:.e_field.minus.:.values']='?'                                            #[ADD?]# 1.625000 # e_field  [V.m^-1]
cocos_signals['waves.coherent_wave.:.full_wave.:.e_field.normal.:.values']='?'                                           #[ADD?]# 1.625000 # e_field  [V.m^-1]
cocos_signals['waves.coherent_wave.:.full_wave.:.e_field.plus.:.values']='?'                                             #[ADD?]# 1.625000 # e_field  [V.m^-1]