# THIS FILE IS GENERATED BY TRANSLATING the `omas_imas.py` SCRIPT
# DO NOT EDIT THIS FILE BECAUSE IT WILL BE OVERWRITTEN


'''save/load from ITM routines

-------
'''

from __future__ import print_function, division, unicode_literals

from .omas_utils import *
from .omas_core import ODS


# --------------------------------------------
# ITM convenience functions
# --------------------------------------------

# AUTOMATICALLY GENERATED FILE - DO NOT EDIT

def itm_open(user, machine, pulse, run, new=False,
              itm_version=os.environ.get('ITM_VERSION', omas_rcparams['default_itm_version'])):
    """
    function to open an ITM

    :param user: ITM username

    :param machine: ITM machine

    :param pulse: ITM pulse

    :param run: ITM run id

    :param new: whether the open should create a new ITM tree

    :param itm_version: ITM version

    :return: ITM cpo
    """
    import ual
    printd("cpo = ual.itm(%d,%d)" % (pulse, run), topic='itm_code')
    cpo = ual.itm(pulse, run)

    if user is None and machine is None:
        pass
    elif user is None or machine is None:
        raise (Exception('user={user}, machine={machine}, itm_version={itm_version}\n'
                         'Either specify all or none of `user`, `machine`, `itm_version`\n'
                         'If none of them are specified then use `itmdb` command to set '
                         'MDSPLUS_TREE_BASE_? environmental variables'.format(user=user, machine=machine, pulse=pulse,
                                                                              run=run, itm_version=itm_version)))

    if user is None and machine is None:
        if new:
            printd("cpo.create()", topic='itm_code')
            cpo.create()
        else:
            printd("cpo.open()", topic='itm_code')
            try:
                cpo.open()
            except Exception as _excp:
                if 'Error opening itm pulse' in str(_excp):
                    raise (IOError('Error opening itm pulse %d run %d' % (pulse, run)))
        if not cpo.isConnected():
            raise (Exception('Failed to establish connection to ITM database '
                             '(pulse:{pulse} run:{run}, DB:{db})'.format(pulse=pulse, run=run, db=os.environ.get('MDSPLUS_TREE_BASE_0', '???')[:-2])))

    else:
        if new:
            printd("cpo.create_env(%s, %s, %s)" % (repr(user), repr(machine), repr(itm_version)), topic='itm_code')
            cpo.create_env(user, machine, itm_version)
        else:
            printd("cpo.open_env(%s, %s, %s)" % (repr(user), repr(machine), repr(itm_version)), topic='itm_code')
            try:
                cpo.open_env(user, machine, itm_version)
            except Exception as _excp:
                if 'Error opening itm pulse' in str(_excp):
                    raise (IOError('Error opening itm pulse (user:%s machine:%s pulse:%s run:%s, itm_version:%s)' % (user, machine, pulse, run, itm_version)))
        if not cpo.isConnected():
            raise (Exception('Failed to establish connection to ITM database (user:%s machine:%s pulse:%s run:%s, itm_version:%s)' % (user, machine, pulse, run, itm_version)))
    return cpo



# AUTOMATICALLY GENERATED FILE - DO NOT EDIT

def itm_set(cpo, path, value, skip_missing_nodes=False, allocate=False):
    """
    assign a value to a path of an open ITM cpo

    :param cpo: open ITM cpo to write to

    :param path: ODS path

    :param value: value to assign

    :param skip_missing_nodes:  if the ITM path does not exists:
                             `False` raise an error
                             `True` does not raise error
                             `None` prints a warning message

    :param allocate: whether to perform only ITM memory allocation (cpo.resize)

    :return: path if set was done, otherwise None
    """
    if numpy.atleast_1d(is_uncertain(value)).any():
        path = copy.deepcopy(path)
        tmp = itm_set(cpo, path, nominal_values(value), skip_missing_nodes=skip_missing_nodes, allocate=allocate)
        path[-1] = path[-1] + '_error_upper'
        itm_set(cpo, path, std_devs(value), skip_missing_nodes=skip_missing_nodes, allocate=allocate)
        return tmp

    ds = path[0]
    path = path[1:]

    # `info` CPO is used by OMAS to hold user, machine, pulse, run, itm_version
    # for saving methods that do not carry that information. ITM does not store
    # this information as part of the data dictionary.
    if ds in add_datastructures.keys():
        return

    # for ITM we have to append Array to the name of the data structure
    DS = ds
    if 'itm' == 'itm':
        ds = ds + 'Array'

    # identify data dictionary to use, from this point on `m` points to the CPO
    debug_path = ''
    if hasattr(cpo, ds):
        debug_path += 'cpo.%s' % ds
        m = getattr(cpo, ds)
        if hasattr(m, 'time') and not isinstance(m.time, float) and not m.time.size:
            m.time.resize(1)
            m.time[0] = -1.0
    elif skip_missing_nodes is not False:
        if skip_missing_nodes is None:
            printe('WARNING: %s is not part of ITM structure' % l2i([ds] + path))
        return
    else:
        printd(debug_path, topic='itm_code')
        raise (AttributeError('%s is not part of ITM structure' % l2i([ds] + path)))

    # traverse ITM structure until reaching the leaf
    out = m
    for kp, p in enumerate(path):
        location = l2i([ds] + path[:kp + 1])
        if isinstance(p, basestring):
            if hasattr(out, p):
                if kp < (len(path) - 1):
                    debug_path += '.' + p
                    out = getattr(out, p)
            elif skip_missing_nodes is not False:
                if skip_missing_nodes is None:
                    printe('WARNING: %s is not part of ITM structure' % location)
                return
            else:
                printd(debug_path, topic='itm_code')
                raise (AttributeError('%s is not part of ITM structure' % location))
        else:
            try:
                out = out[p]
                debug_path += '[%d]' % p
            except (AttributeError, IndexError):  # AttributeError is for ITM
                if not allocate:
                    raise (IndexError('%s structure array exceed allocation' % location))
                printd(debug_path + ".resize(%d)" % (p + 1), topic='itm_code')
                out.resize(p + 1)
                debug_path += '[%d]' % p
                out = out[p]

    # if we are allocating data, simply stop here
    if allocate:
        return [DS] + path

    # assign data to leaf node
    printd('setting  : %s' % location, topic='itm')
    if not isinstance(value, (basestring, numpy.ndarray)):
        value = numpy.array(value)
    setattr(out, path[-1], value)
    if 'itm_code' in os.environ.get('OMAS_DEBUG_TOPIC', ''):  # use if statement here to avoid unecessary repr(value) when not debugging
        printd(debug_path + '.%s=%s' % (path[-1], repr(value).replace('\\n', '\n')), topic='itm_code')

    # return path
    return [DS] + path



# AUTOMATICALLY GENERATED FILE - DO NOT EDIT

def itm_get(cpo, path, skip_missing_nodes=False):
    """
    read the value of a path in an open ITM cpo

    :param cpo: open ITM cpo to read from

    :param path: ODS path

    :param skip_missing_nodes:  if the ITM path does not exists:
                             `False` raise an error
                             `True` does not raise error
                             `None` prints a warning message

    :return: the value that was read if successful or None otherwise
    """
    printd('fetching: %s' % l2i(path), topic='itm')
    ds = path[0]
    path = path[1:]

    # for ITM we have to append Array to the name of the data structure
    if 'itm' == 'itm':
        ds = ds + 'Array'

    debug_path = ''
    if hasattr(cpo, ds):
        debug_path += 'cpo.%s' % ds
        m = getattr(cpo, ds)
    elif skip_missing_nodes is not False:
        if skip_missing_nodes is None:
            printe('WARNING: %s is not part of ITM structure' % l2i([ds] + path))
        return None
    else:
        printd(debug_path, topic='itm_code')
        raise (AttributeError('%s is not part of ITM structure' % l2i([ds] + path)))

    # traverse the CPO to get the data
    out = m
    for kp, p in enumerate(path):
        if isinstance(p, basestring):
            if hasattr(out, p):
                debug_path += '.%s' % p
                out = getattr(out, p)
            elif skip_missing_nodes is not False:
                if skip_missing_nodes is None:
                    printe('WARNING: %s is not part of ITM structure' % l2i([ds] + path[:kp + 1]))
                    printe(out.__dict__.keys())
                return None
            else:
                printd(debug_path, topic='itm_code')
                raise (AttributeError('%s is not part of ITM structure' % l2i([ds] + path[:kp + 1])))
        else:
            debug_path += '[%s]' % p
            out = out[p]

    # handle missing data
    data = out
    if len(path) == 2 and path[-1] == 'time' and data[0] < 0:
        data = None
    # skip empty arrays
    elif isinstance(data, numpy.ndarray) and not data.size:
        data = None
    # skip missing floats and integers
    elif (isinstance(data, float) and data == -9E40) or (isinstance(data, int) and data == -999999999):
        data = None
    # skip empty strings
    elif isinstance(data, unicode) and not len(data):
        data = None

    printd(debug_path, topic='itm_code')
    return data


# --------------------------------------------
# save and load OMAS to ITM
# --------------------------------------------

# AUTOMATICALLY GENERATED FILE - DO NOT EDIT

def save_omas_itm(ods, user=None, machine=None, pulse=None, run=None, new=False,
                   itm_version=os.environ.get('ITM_VERSION', omas_rcparams['default_itm_version'])):
    """
    Save OMAS data to ITM

    :param ods: OMAS data set

    :param user: ITM username (reads ods['dataset_description.data_entry.user'] if user is None and finally fallsback on os.environ['USER'])

    :param machine: ITM machine (reads ods['dataset_description.data_entry.machine'] if machine is None)

    :param pulse: ITM pulse (reads ods['dataset_description.data_entry.pulse'] if pulse is None)

    :param run: ITM run (reads ods['dataset_description.data_entry.run'] if run is None and finally fallsback on 0)

    :param new: whether the open should create a new ITM tree

    :param itm_version: ITM version

    :return: paths that have been written to ITM
    """

    # handle default values for user, machine, pulse, run, itm_version
    # it tries to re-use existing information
    if user is None:
        user = ods.get('dataset_description.data_entry.user', os.environ['USER'])
    if machine is None:
        machine = ods.get('dataset_description.data_entry.machine', None)
    if pulse is None:
        pulse = ods.get('dataset_description.data_entry.pulse', None)
    if run is None:
        run = ods.get('dataset_description.data_entry.run', 0)

    # set dataset_description entries that were empty
    if user is not None and 'dataset_description.data_entry.user' not in ods:
        ods['dataset_description.data_entry.user'] = user
    if machine is not None and 'dataset_description.data_entry.machine' not in ods:
        ods['dataset_description.data_entry.machine'] = machine
    if pulse is not None and 'dataset_description.data_entry.pulse' not in ods:
        ods['dataset_description.data_entry.pulse'] = pulse
    if run is not None and 'dataset_description.data_entry.run' not in ods:
        ods['dataset_description.data_entry.run'] = run
    if itm_version is not None and 'dataset_description.itm_version' not in ods:
        ods['dataset_description.itm_version'] = itm_version

    if user is not None and machine is not None:
        printd('Saving to ITM (user:%s machine:%s pulse:%d run:%d, itm_version:%s)' % (user, machine, pulse, run, itm_version), topic='itm')
    elif user is None and machine is None:
        printd('Saving to ITM (pulse:%d run:%d, DB:%s)' % (pulse, run, os.environ.get('MDSPLUS_TREE_BASE_0', '???')[:-2]), topic='itm')

    # ensure requirements for writing data to ITM are satisfied
    if 'itm' != 'itm':
        for ds in ods.keys():
            ods[ds].satisfy_itm_requirements()

    # get the list of paths from ODS
    paths = set_paths = ods.paths()

    try:
        # open ITM tree
        cpo = itm_open(user=user, machine=machine, pulse=pulse, run=run, new=new, itm_version=itm_version)

    except IOError as _excp:
        raise (IOError(str(_excp) + '\nIf this is a new pulse/run then set `new=True`'))

    except ImportError:
        # fallback on saving ITM as NC file if ITM is not installed
        if not omas_rcparams['allow_fake_itm_fallback']:
            raise
        filename = os.sep.join([omas_rcparams['fake_itm_dir'], '%s_%s_%d_%d_v%s.pkl' % (user, machine, pulse, run, itm_versions.get(itm_version, itm_version))])
        printe('Overloaded save_omas_itm: %s' % filename)
        from . import save_omas_pkl
        if not os.path.exists(omas_rcparams['fake_itm_dir']):
            os.makedirs(omas_rcparams['fake_itm_dir'])
        ods['dataset_description.data_entry.user'] = unicode(user)
        ods['dataset_description.data_entry.machine'] = unicode(machine)
        ods['dataset_description.data_entry.pulse'] = int(pulse)
        ods['dataset_description.data_entry.run'] = int(run)
        ods['dataset_description.itm_version'] = unicode(itm_version)
        save_omas_pkl(ods, filename)

    else:

        try:
            # allocate memory
            # NOTE: for how memory allocation works it is important to traverse the tree in reverse
            set_paths = []
            for path in reversed(paths):
                set_paths.append(itm_set(cpo, path, ods[path], None, allocate=True))
            set_paths = filter(None, set_paths)

            # assign the data
            for path in set_paths:
                printd('writing %s' % l2i(path))
                itm_set(cpo, path, ods[path], True)

            # actual write of CPO data to ITM database
            for ds in ods.keys():
                if ds in add_datastructures.keys():
                    continue
                if 'itm' == 'itm':
                    ds = ds + 'Array'
                printd("cpo.%s.put(0)" % ds, topic='itm_code')
                getattr(cpo, ds).put(0)

        finally:
            # close connection to ITM database
            printd("cpo.close()", topic='itm_code')
            cpo.close()

    return set_paths



# AUTOMATICALLY GENERATED FILE - DO NOT EDIT

def load_omas_itm(user=os.environ['USER'], machine=None, pulse=None, run=0, paths=None,
                   itm_version=os.environ.get('ITM_VERSION', omas_rcparams['default_itm_version']), verbose=True):
    """
    Load OMAS data from ITM

    NOTE: Either specify all or none of `user`, `machine`, `itm_version`
    If none of them are specified then use `itmdb` command to set the `MDSPLUS_TREE_BASE_?` environmental variables

    :param user: ITM username

    :param machine: ITM machine

    :param pulse: ITM pulse

    :param run: ITM run

    :param paths: list of paths to load from ITM

    :param itm_version: ITM version

    :param verbose: print loading progress

    :return: OMAS data set
    """

    if pulse is None or run is None:
        raise (Exception('`pulse` and `run` must be specified'))

    printd('Loading from ITM (user:%s machine:%s pulse:%d run:%d, itm_version:%s)' % (user, machine, pulse, run, itm_version), topic='itm')

    try:
        cpo = itm_open(user=user, machine=machine, pulse=pulse, run=run, new=False, itm_version=itm_version)

    except ImportError:
        if not omas_rcparams['allow_fake_itm_fallback']:
            raise
        filename = os.sep.join([omas_rcparams['fake_itm_dir'], '%s_%s_%d_%d_v%s.pkl' % (user, machine, pulse, run, itm_versions.get(itm_version, itm_version))])
        printe('Overloaded load_omas_itm: %s' % filename)
        from . import load_omas_pkl
        ods = load_omas_pkl(filename)

    else:

        try:
            # if paths is None then figure out what CPO are available and get ready to retrieve everything
            if paths is None:
                paths = [[structure] for structure in list_structures(itm_version=itm_version)]
                joined_paths = None # joined_paths==None means take everything, no need to filter out what is available based on what was requested
            else:
                joined_paths = map(l2i, paths)

            # fetch relevant CPOs and find available signals
            fetch_paths = []
            for path in paths:
                ds = path[0]
                path = path[1:]
                if ds in add_datastructures.keys():
                    continue
                if not hasattr(cpo, ds):
                    if verbose:
                        print('| ', ds)
                    continue
                # cpo fetching
                if not len(getattr(cpo, ds).time):
                    printd("cpo.%s.get()" % ds, topic='itm_code')
                    getattr(cpo, ds).get()
                # cpo discovery
                if len(getattr(cpo, ds).time):
                    if verbose:
                        print('* ', ds)
                    available_paths = filled_paths_in_cpo(cpo, load_structure(ds, itm_version=itm_version)[1], [], [])
                    if joined_paths is None:
                        # if joined_paths is None, this means the user requested everything
                        fetch_paths = available_paths
                    else:
                        # intersect between what was requested and what is available
                        joined_available_paths = map(l2i, available_paths)
                        for jpath, path in zip(joined_paths, paths):
                            if path[0] != ds:
                                continue
                            jpath = jpath.replace('.', '\.')
                            jpath = '^' + jpath.replace('.:', '.[0-9]+') + '.*'
                            for japath, apath in zip(joined_available_paths, available_paths):
                                if re.match(jpath, japath):
                                    fetch_paths.append(apath)
                else:
                    if verbose:
                        print('- ', ds)
            joined_fetch_paths = map(l2i, fetch_paths)

            # build omas data structure
            ods = ODS(itm_version=itm_version)
            for k, path in enumerate(fetch_paths):
                if path[-1].endswith('_error_upper') or path[-1].endswith('_error_lower'):
                    continue
                if verbose:
                    print('Loading data: {0:3.3f}%'.format(100 * float(k) / len(fetch_paths)))
                # get data from cpo
                data = itm_get(cpo, path, None)
                # continue for empty data
                if data is None:
                    continue
                # add uncertainty
                if l2i(path[:-1] + [path[-1] + '_error_upper']) in joined_fetch_paths:
                    stdata = itm_get(cpo, path[:-1] + [path[-1] + '_error_upper'], None)
                    if stdata is not None:
                        try:
                            data = uarray(data, stdata)
                        except uncertainties.core.NegativeStdDev as _excp:
                            printe('Error loading uncertainty for %s: %s' % (l2i(path), repr(_excp)))
                # assign data to ODS
                h = ods
                for step in path[:-1]:
                    h = h[step]
                h[path[-1]] = data

        finally:
            # close connection to ITM database
            printd("cpo.close()", topic='itm_code')
            cpo.close()

    ods['dataset_description.data_entry.user'] = unicode(user)
    ods['dataset_description.data_entry.machine'] = unicode(machine)
    ods['dataset_description.data_entry.pulse'] = int(pulse)
    ods['dataset_description.data_entry.run'] = int(run)
    ods['dataset_description.itm_version'] = unicode(itm_version)

    return ods


if 'itm' != 'itm':
    def browse_itm(user=os.environ['USER'], pretty=True, quiet=False,
                    user_itmdbdir=os.sep.join([os.environ['HOME'], 'public', 'itmdb'])):
        '''
        Browse available ITM data (machine/pulse/run) for given user

        :param user: user (of list of users) to browse. Browses all users if None.

        :param pretty: express size in MB and time in human readeable format

        :param quiet: print database to screen

        :param user_itmdbdir: directory where itmdb is located for current user (typically $HOME/public/itmdb/)

        :return: hierarchical dictionary with database of available ITM data (machine/pulse/run) for given user
        '''
        # if no users are specified, find all users
        if user is None:
            user = glob.glob(user_itmdbdir.replace('/%s/' % os.environ['USER'], '/*/'))
            user = map(lambda x: x.split(os.sep)[-3], user)
        elif isinstance(user, basestring):
            user = [user]

        # build database for each user
        itmdb = {}
        for username in user:
            itmdb[username] = {}
            itmdbdir = user_itmdbdir.replace('/%s/' % os.environ['USER'], '/%s/' % username).strip()

            # find MDS+ datafiles
            files = list(recursive_glob('*datafile', itmdbdir))

            # extract machine/pulse/run from filename of MDS+ datafiles
            for file in files:
                tmp = file.split(os.sep)
                if not re.match('cpo_[0-9]{5,}.datafile', tmp[-1]):
                    continue
                pulse_run = tmp[-1].split('.')[0].split('_')[1]
                pulse = int(pulse_run[:-4])
                run = int(pulse_run[-4:])
                machine = tmp[-4]

                # size and data
                st = os.stat(file)
                size = st.st_size
                date = st.st_mtime
                if pretty:
                    import time
                    size = '%d Mb' % (int(size / 1024 / 1024))
                    date = time.strftime('%d/%m/%y - %H:%M', time.localtime(date))

                # build database
                if machine not in itmdb[username]:
                    itmdb[username][machine] = {}
                itmdb[username][machine][pulse, run] = {'size': size, 'date': date}

        # print if not quiet
        if not quiet:
            pprint(itmdb)

        # return database
        return itmdb


    def load_omas_iter_scenario(pulse, run=0, paths=None,
                                itm_version=os.environ.get('ITM_VERSION', omas_rcparams['default_itm_version']),
                                verbose=True):
        """
        Load OMAS data set from ITER ITM scenario database
    
        :param pulse: ITM pulse
    
        :param run: ITM run
    
        :param paths: list of paths to load from ITM
    
        :param itm_version: ITM version
    
        :return: OMAS data set
    
        :param verbose: print loading progress
        """
        # set MDSPLUS_TREE_BASE_? environment variables as per
        # itmdb /work/itm/shared/iterdb/3 ; env | grep MDSPLUS_TREE_BASE
        try:
            bkp_itm_environment = {}
            for k in range(10):
                if 'MDSPLUS_TREE_BASE_%d' % k in os.environ:
                    bkp_itm_environment['MDSPLUS_TREE_BASE_%d' % k] = os.environ['MDSPLUS_TREE_BASE_%d' % k]
                os.environ['MDSPLUS_TREE_BASE_%d' % k] = '/work/itm/shared/iterdb/3/%d' % k

            # load data from itm
            ods = load_omas_itm(user=None, machine=None, pulse=pulse, run=run, paths=paths, itm_version=itm_version, verbose=verbose)

        finally:
            # restore existing ITM environment
            for k in range(10):
                del os.environ['MDSPLUS_TREE_BASE_%d' % k]
                os.environ.update(bkp_itm_environment)

        return ods



# AUTOMATICALLY GENERATED FILE - DO NOT EDIT

def filled_paths_in_cpo(cpo, ds, path=None, paths=None, assume_uniform_array_structures=False):
    """
    Taverse an CPO and list leaf paths (with proper sizing for arrays of structures)

    :param cpo: input cpo

    :param ds: hierarchical data schema as returned for example by load_structure('equilibrium')[1]

    :param assume_uniform_array_structures: assume that the first structure in an array of structures has data in the same nodes locations of the later structures in the array

    :return: returns list of paths in an CPO that are filled
    """
    if path is None:
        path = []

    if paths is None:
        paths = []

    # leaf
    if not len(ds):
        paths.append(path)
        #print(paths[-1])
        return paths

    # keys
    keys = ds.keys()
    if keys[0] == ':':
        keys = range(len(cpo))
        if len(keys) and assume_uniform_array_structures:
            keys = [0]

    # traverse
    for kid in keys:
        propagate_path = copy.copy(path)
        propagate_path.append(kid)
        if isinstance(kid, basestring):
            subtree_paths = filled_paths_in_cpo(getattr(cpo, kid), ds[kid], propagate_path, [], assume_uniform_array_structures)
        else:
            subtree_paths = filled_paths_in_cpo(cpo[kid], ds[':'], propagate_path, [], assume_uniform_array_structures)
        paths += subtree_paths

        # assume_uniform_array_structures
        if keys[0]==0 and assume_uniform_array_structures:
            zero_paths = subtree_paths
            for key in range(1, len(cpo)):
                subtree_paths = copy.deepcopy(zero_paths)
                for p in subtree_paths:
                    p[len(path)] = key
                paths += subtree_paths

    return paths



# AUTOMATICALLY GENERATED FILE - DO NOT EDIT

def through_omas_itm(ods):
    """
    test save and load OMAS ITM

    :param ods: ods

    :return: ods
    """
    user = os.environ['USER']
    machine = 'ITER'
    pulse = 1
    run = 0

    paths = save_omas_itm(ods, user=user, machine=machine, pulse=pulse, run=run, new=True)
    ods1 = load_omas_itm(user=user, machine=machine, pulse=pulse, run=run, paths=paths)
    return ods1
