"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvocationAlarm = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const constructs_1 = require("constructs");
/**
 * Cloudwatch Alarm used across this construct library.
 */
class InvocationAlarm extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new aws_cloudwatch_1.Alarm(this, 'InvocationAlarm', {
            alarmDescription: `Alarm for ${aws_cdk_lib_1.Stack.of(this).stackName} - InboundWebhook Lambda for traffic spikes`,
            alarmName: `InboundWebhook-Lambda-Invocation-Alarm-${aws_cdk_lib_1.Stack.of(this).stackName}`,
            evaluationPeriods: 2,
            metric: new aws_cloudwatch_1.Metric({
                metricName: 'Invocations',
                namespace: 'AWS/Lambda',
                period: aws_cdk_lib_1.Duration.seconds(300),
                statistic: 'Sum',
                dimensionsMap: {
                    Name: 'FunctionName',
                    Value: props.eventFunction.functionName,
                },
            }),
            threshold: props.threshold,
            comparisonOperator: aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
        });
    }
}
exports.InvocationAlarm = InvocationAlarm;
_a = JSII_RTTI_SYMBOL_1;
InvocationAlarm[_a] = { fqn: "cdk-eventbridge-partner-processors.InvocationAlarm", version: "0.0.73" };
//# sourceMappingURL=data:application/json;base64,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