import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementApiVersionSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#api_management_name ApiManagementApiVersionSet#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#description ApiManagementApiVersionSet#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#display_name ApiManagementApiVersionSet#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#name ApiManagementApiVersionSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#resource_group_name ApiManagementApiVersionSet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#version_header_name ApiManagementApiVersionSet#version_header_name}
    */
    readonly versionHeaderName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#version_query_name ApiManagementApiVersionSet#version_query_name}
    */
    readonly versionQueryName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#versioning_scheme ApiManagementApiVersionSet#versioning_scheme}
    */
    readonly versioningScheme: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#timeouts ApiManagementApiVersionSet#timeouts}
    */
    readonly timeouts?: ApiManagementApiVersionSetTimeouts;
}
export interface ApiManagementApiVersionSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#create ApiManagementApiVersionSet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#delete ApiManagementApiVersionSet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#read ApiManagementApiVersionSet#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set#update ApiManagementApiVersionSet#update}
    */
    readonly update?: string;
}
export declare function apiManagementApiVersionSetTimeoutsToTerraform(struct?: ApiManagementApiVersionSetTimeoutsOutputReference | ApiManagementApiVersionSetTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementApiVersionSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ApiManagementApiVersionSetTimeouts | undefined;
    set internalValue(value: ApiManagementApiVersionSetTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set azurerm_api_management_api_version_set}
*/
export declare class ApiManagementApiVersionSet extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_version_set azurerm_api_management_api_version_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementApiVersionSetConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementApiVersionSetConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _versionHeaderName?;
    get versionHeaderName(): string;
    set versionHeaderName(value: string);
    resetVersionHeaderName(): void;
    get versionHeaderNameInput(): string | undefined;
    private _versionQueryName?;
    get versionQueryName(): string;
    set versionQueryName(value: string);
    resetVersionQueryName(): void;
    get versionQueryNameInput(): string | undefined;
    private _versioningScheme?;
    get versioningScheme(): string;
    set versioningScheme(value: string);
    get versioningSchemeInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementApiVersionSetTimeoutsOutputReference;
    putTimeouts(value: ApiManagementApiVersionSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementApiVersionSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
