import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementAuthorizationServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#api_management_name ApiManagementAuthorizationServer#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#authorization_endpoint ApiManagementAuthorizationServer#authorization_endpoint}
    */
    readonly authorizationEndpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#authorization_methods ApiManagementAuthorizationServer#authorization_methods}
    */
    readonly authorizationMethods: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#bearer_token_sending_methods ApiManagementAuthorizationServer#bearer_token_sending_methods}
    */
    readonly bearerTokenSendingMethods?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#client_authentication_method ApiManagementAuthorizationServer#client_authentication_method}
    */
    readonly clientAuthenticationMethod?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#client_id ApiManagementAuthorizationServer#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#client_registration_endpoint ApiManagementAuthorizationServer#client_registration_endpoint}
    */
    readonly clientRegistrationEndpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#client_secret ApiManagementAuthorizationServer#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#default_scope ApiManagementAuthorizationServer#default_scope}
    */
    readonly defaultScope?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#description ApiManagementAuthorizationServer#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#display_name ApiManagementAuthorizationServer#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#grant_types ApiManagementAuthorizationServer#grant_types}
    */
    readonly grantTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#name ApiManagementAuthorizationServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#resource_group_name ApiManagementAuthorizationServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#resource_owner_password ApiManagementAuthorizationServer#resource_owner_password}
    */
    readonly resourceOwnerPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#resource_owner_username ApiManagementAuthorizationServer#resource_owner_username}
    */
    readonly resourceOwnerUsername?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#support_state ApiManagementAuthorizationServer#support_state}
    */
    readonly supportState?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#token_endpoint ApiManagementAuthorizationServer#token_endpoint}
    */
    readonly tokenEndpoint?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#timeouts ApiManagementAuthorizationServer#timeouts}
    */
    readonly timeouts?: ApiManagementAuthorizationServerTimeouts;
    /**
    * token_body_parameter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#token_body_parameter ApiManagementAuthorizationServer#token_body_parameter}
    */
    readonly tokenBodyParameter?: ApiManagementAuthorizationServerTokenBodyParameter[] | cdktf.IResolvable;
}
export interface ApiManagementAuthorizationServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#create ApiManagementAuthorizationServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#delete ApiManagementAuthorizationServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#read ApiManagementAuthorizationServer#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#update ApiManagementAuthorizationServer#update}
    */
    readonly update?: string;
}
export declare function apiManagementAuthorizationServerTimeoutsToTerraform(struct?: ApiManagementAuthorizationServerTimeoutsOutputReference | ApiManagementAuthorizationServerTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementAuthorizationServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ApiManagementAuthorizationServerTimeouts | undefined;
    set internalValue(value: ApiManagementAuthorizationServerTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ApiManagementAuthorizationServerTokenBodyParameter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#name ApiManagementAuthorizationServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server#value ApiManagementAuthorizationServer#value}
    */
    readonly value: string;
}
export declare function apiManagementAuthorizationServerTokenBodyParameterToTerraform(struct?: ApiManagementAuthorizationServerTokenBodyParameter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server azurerm_api_management_authorization_server}
*/
export declare class ApiManagementAuthorizationServer extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_authorization_server azurerm_api_management_authorization_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementAuthorizationServerConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementAuthorizationServerConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _authorizationEndpoint?;
    get authorizationEndpoint(): string;
    set authorizationEndpoint(value: string);
    get authorizationEndpointInput(): string | undefined;
    private _authorizationMethods?;
    get authorizationMethods(): string[];
    set authorizationMethods(value: string[]);
    get authorizationMethodsInput(): string[] | undefined;
    private _bearerTokenSendingMethods?;
    get bearerTokenSendingMethods(): string[];
    set bearerTokenSendingMethods(value: string[]);
    resetBearerTokenSendingMethods(): void;
    get bearerTokenSendingMethodsInput(): string[] | undefined;
    private _clientAuthenticationMethod?;
    get clientAuthenticationMethod(): string[];
    set clientAuthenticationMethod(value: string[]);
    resetClientAuthenticationMethod(): void;
    get clientAuthenticationMethodInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientRegistrationEndpoint?;
    get clientRegistrationEndpoint(): string;
    set clientRegistrationEndpoint(value: string);
    get clientRegistrationEndpointInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _defaultScope?;
    get defaultScope(): string;
    set defaultScope(value: string);
    resetDefaultScope(): void;
    get defaultScopeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _grantTypes?;
    get grantTypes(): string[];
    set grantTypes(value: string[]);
    get grantTypesInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _resourceOwnerPassword?;
    get resourceOwnerPassword(): string;
    set resourceOwnerPassword(value: string);
    resetResourceOwnerPassword(): void;
    get resourceOwnerPasswordInput(): string | undefined;
    private _resourceOwnerUsername?;
    get resourceOwnerUsername(): string;
    set resourceOwnerUsername(value: string);
    resetResourceOwnerUsername(): void;
    get resourceOwnerUsernameInput(): string | undefined;
    private _supportState?;
    get supportState(): boolean | cdktf.IResolvable;
    set supportState(value: boolean | cdktf.IResolvable);
    resetSupportState(): void;
    get supportStateInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenEndpoint?;
    get tokenEndpoint(): string;
    set tokenEndpoint(value: string);
    resetTokenEndpoint(): void;
    get tokenEndpointInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementAuthorizationServerTimeoutsOutputReference;
    putTimeouts(value: ApiManagementAuthorizationServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementAuthorizationServerTimeouts | undefined;
    private _tokenBodyParameter?;
    get tokenBodyParameter(): ApiManagementAuthorizationServerTokenBodyParameter[] | cdktf.IResolvable;
    set tokenBodyParameter(value: ApiManagementAuthorizationServerTokenBodyParameter[] | cdktf.IResolvable);
    resetTokenBodyParameter(): void;
    get tokenBodyParameterInput(): cdktf.IResolvable | ApiManagementAuthorizationServerTokenBodyParameter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
