import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#location AppConfiguration#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#name AppConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#resource_group_name AppConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#sku AppConfiguration#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#tags AppConfiguration#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#identity AppConfiguration#identity}
    */
    readonly identity?: AppConfigurationIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#timeouts AppConfiguration#timeouts}
    */
    readonly timeouts?: AppConfigurationTimeouts;
}
export declare class AppConfigurationPrimaryReadKey extends cdktf.ComplexComputedList {
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class AppConfigurationPrimaryWriteKey extends cdktf.ComplexComputedList {
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class AppConfigurationSecondaryReadKey extends cdktf.ComplexComputedList {
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class AppConfigurationSecondaryWriteKey extends cdktf.ComplexComputedList {
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export interface AppConfigurationIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#identity_ids AppConfiguration#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#type AppConfiguration#type}
    */
    readonly type: string;
}
export declare function appConfigurationIdentityToTerraform(struct?: AppConfigurationIdentityOutputReference | AppConfigurationIdentity): any;
export declare class AppConfigurationIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppConfigurationIdentity | undefined;
    set internalValue(value: AppConfigurationIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface AppConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#create AppConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#delete AppConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#read AppConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration#update AppConfiguration#update}
    */
    readonly update?: string;
}
export declare function appConfigurationTimeoutsToTerraform(struct?: AppConfigurationTimeoutsOutputReference | AppConfigurationTimeouts | cdktf.IResolvable): any;
export declare class AppConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppConfigurationTimeouts | undefined;
    set internalValue(value: AppConfigurationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration azurerm_app_configuration}
*/
export declare class AppConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_configuration azurerm_app_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: AppConfigurationConfig);
    get endpoint(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    primaryReadKey(index: string): AppConfigurationPrimaryReadKey;
    primaryWriteKey(index: string): AppConfigurationPrimaryWriteKey;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    secondaryReadKey(index: string): AppConfigurationSecondaryReadKey;
    secondaryWriteKey(index: string): AppConfigurationSecondaryWriteKey;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): AppConfigurationIdentityOutputReference;
    putIdentity(value: AppConfigurationIdentity): void;
    resetIdentity(): void;
    get identityInput(): AppConfigurationIdentity | undefined;
    private _timeouts;
    get timeouts(): AppConfigurationTimeoutsOutputReference;
    putTimeouts(value: AppConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
