import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BotChannelsRegistrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#cmk_key_vault_url BotChannelsRegistration#cmk_key_vault_url}
    */
    readonly cmkKeyVaultUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#description BotChannelsRegistration#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#developer_app_insights_api_key BotChannelsRegistration#developer_app_insights_api_key}
    */
    readonly developerAppInsightsApiKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#developer_app_insights_application_id BotChannelsRegistration#developer_app_insights_application_id}
    */
    readonly developerAppInsightsApplicationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#developer_app_insights_key BotChannelsRegistration#developer_app_insights_key}
    */
    readonly developerAppInsightsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#display_name BotChannelsRegistration#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#endpoint BotChannelsRegistration#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#icon_url BotChannelsRegistration#icon_url}
    */
    readonly iconUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#isolated_network_enabled BotChannelsRegistration#isolated_network_enabled}
    */
    readonly isolatedNetworkEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#location BotChannelsRegistration#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#microsoft_app_id BotChannelsRegistration#microsoft_app_id}
    */
    readonly microsoftAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#name BotChannelsRegistration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#resource_group_name BotChannelsRegistration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#sku BotChannelsRegistration#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#tags BotChannelsRegistration#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#timeouts BotChannelsRegistration#timeouts}
    */
    readonly timeouts?: BotChannelsRegistrationTimeouts;
}
export interface BotChannelsRegistrationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#create BotChannelsRegistration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#delete BotChannelsRegistration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#read BotChannelsRegistration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration#update BotChannelsRegistration#update}
    */
    readonly update?: string;
}
export declare function botChannelsRegistrationTimeoutsToTerraform(struct?: BotChannelsRegistrationTimeoutsOutputReference | BotChannelsRegistrationTimeouts | cdktf.IResolvable): any;
export declare class BotChannelsRegistrationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): BotChannelsRegistrationTimeouts | undefined;
    set internalValue(value: BotChannelsRegistrationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration azurerm_bot_channels_registration}
*/
export declare class BotChannelsRegistration extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channels_registration azurerm_bot_channels_registration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BotChannelsRegistrationConfig
    */
    constructor(scope: Construct, id: string, config: BotChannelsRegistrationConfig);
    private _cmkKeyVaultUrl?;
    get cmkKeyVaultUrl(): string;
    set cmkKeyVaultUrl(value: string);
    resetCmkKeyVaultUrl(): void;
    get cmkKeyVaultUrlInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _developerAppInsightsApiKey?;
    get developerAppInsightsApiKey(): string;
    set developerAppInsightsApiKey(value: string);
    resetDeveloperAppInsightsApiKey(): void;
    get developerAppInsightsApiKeyInput(): string | undefined;
    private _developerAppInsightsApplicationId?;
    get developerAppInsightsApplicationId(): string;
    set developerAppInsightsApplicationId(value: string);
    resetDeveloperAppInsightsApplicationId(): void;
    get developerAppInsightsApplicationIdInput(): string | undefined;
    private _developerAppInsightsKey?;
    get developerAppInsightsKey(): string;
    set developerAppInsightsKey(value: string);
    resetDeveloperAppInsightsKey(): void;
    get developerAppInsightsKeyInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _iconUrl?;
    get iconUrl(): string;
    set iconUrl(value: string);
    resetIconUrl(): void;
    get iconUrlInput(): string | undefined;
    get id(): string;
    private _isolatedNetworkEnabled?;
    get isolatedNetworkEnabled(): boolean | cdktf.IResolvable;
    set isolatedNetworkEnabled(value: boolean | cdktf.IResolvable);
    resetIsolatedNetworkEnabled(): void;
    get isolatedNetworkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _microsoftAppId?;
    get microsoftAppId(): string;
    set microsoftAppId(value: string);
    get microsoftAppIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): BotChannelsRegistrationTimeoutsOutputReference;
    putTimeouts(value: BotChannelsRegistrationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): BotChannelsRegistrationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
