import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CognitiveAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#custom_subdomain_name CognitiveAccount#custom_subdomain_name}
    */
    readonly customSubdomainName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#fqdns CognitiveAccount#fqdns}
    */
    readonly fqdns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#kind CognitiveAccount#kind}
    */
    readonly kind: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#local_auth_enabled CognitiveAccount#local_auth_enabled}
    */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#location CognitiveAccount#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#metrics_advisor_aad_client_id CognitiveAccount#metrics_advisor_aad_client_id}
    */
    readonly metricsAdvisorAadClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#metrics_advisor_aad_tenant_id CognitiveAccount#metrics_advisor_aad_tenant_id}
    */
    readonly metricsAdvisorAadTenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#metrics_advisor_super_user_name CognitiveAccount#metrics_advisor_super_user_name}
    */
    readonly metricsAdvisorSuperUserName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#metrics_advisor_website_name CognitiveAccount#metrics_advisor_website_name}
    */
    readonly metricsAdvisorWebsiteName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#name CognitiveAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#outbound_network_access_restrited CognitiveAccount#outbound_network_access_restrited}
    */
    readonly outboundNetworkAccessRestrited?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#public_network_access_enabled CognitiveAccount#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#qna_runtime_endpoint CognitiveAccount#qna_runtime_endpoint}
    */
    readonly qnaRuntimeEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#resource_group_name CognitiveAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#sku_name CognitiveAccount#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#tags CognitiveAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#identity CognitiveAccount#identity}
    */
    readonly identity?: CognitiveAccountIdentity;
    /**
    * network_acls block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#network_acls CognitiveAccount#network_acls}
    */
    readonly networkAcls?: CognitiveAccountNetworkAcls;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#storage CognitiveAccount#storage}
    */
    readonly storage?: CognitiveAccountStorage[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#timeouts CognitiveAccount#timeouts}
    */
    readonly timeouts?: CognitiveAccountTimeouts;
}
export interface CognitiveAccountIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#identity_ids CognitiveAccount#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#type CognitiveAccount#type}
    */
    readonly type: string;
}
export declare function cognitiveAccountIdentityToTerraform(struct?: CognitiveAccountIdentityOutputReference | CognitiveAccountIdentity): any;
export declare class CognitiveAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CognitiveAccountIdentity | undefined;
    set internalValue(value: CognitiveAccountIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface CognitiveAccountNetworkAclsVirtualNetworkRules {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#ignore_missing_vnet_service_endpoint CognitiveAccount#ignore_missing_vnet_service_endpoint}
    */
    readonly ignoreMissingVnetServiceEndpoint?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#subnet_id CognitiveAccount#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function cognitiveAccountNetworkAclsVirtualNetworkRulesToTerraform(struct?: CognitiveAccountNetworkAclsVirtualNetworkRules | cdktf.IResolvable): any;
export interface CognitiveAccountNetworkAcls {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#default_action CognitiveAccount#default_action}
    */
    readonly defaultAction: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#ip_rules CognitiveAccount#ip_rules}
    */
    readonly ipRules?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#virtual_network_rules CognitiveAccount#virtual_network_rules}
    */
    readonly virtualNetworkRules?: CognitiveAccountNetworkAclsVirtualNetworkRules[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#virtual_network_subnet_ids CognitiveAccount#virtual_network_subnet_ids}
    */
    readonly virtualNetworkSubnetIds?: string[];
}
export declare function cognitiveAccountNetworkAclsToTerraform(struct?: CognitiveAccountNetworkAclsOutputReference | CognitiveAccountNetworkAcls): any;
export declare class CognitiveAccountNetworkAclsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CognitiveAccountNetworkAcls | undefined;
    set internalValue(value: CognitiveAccountNetworkAcls | undefined);
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    get defaultActionInput(): string | undefined;
    private _ipRules?;
    get ipRules(): string[];
    set ipRules(value: string[]);
    resetIpRules(): void;
    get ipRulesInput(): string[] | undefined;
    private _virtualNetworkRules?;
    get virtualNetworkRules(): CognitiveAccountNetworkAclsVirtualNetworkRules[] | cdktf.IResolvable;
    set virtualNetworkRules(value: CognitiveAccountNetworkAclsVirtualNetworkRules[] | cdktf.IResolvable);
    resetVirtualNetworkRules(): void;
    get virtualNetworkRulesInput(): cdktf.IResolvable | CognitiveAccountNetworkAclsVirtualNetworkRules[] | undefined;
    private _virtualNetworkSubnetIds?;
    get virtualNetworkSubnetIds(): string[];
    set virtualNetworkSubnetIds(value: string[]);
    resetVirtualNetworkSubnetIds(): void;
    get virtualNetworkSubnetIdsInput(): string[] | undefined;
}
export interface CognitiveAccountStorage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#identity_client_id CognitiveAccount#identity_client_id}
    */
    readonly identityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#storage_account_id CognitiveAccount#storage_account_id}
    */
    readonly storageAccountId: string;
}
export declare function cognitiveAccountStorageToTerraform(struct?: CognitiveAccountStorage | cdktf.IResolvable): any;
export interface CognitiveAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#create CognitiveAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#delete CognitiveAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#read CognitiveAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account#update CognitiveAccount#update}
    */
    readonly update?: string;
}
export declare function cognitiveAccountTimeoutsToTerraform(struct?: CognitiveAccountTimeoutsOutputReference | CognitiveAccountTimeouts | cdktf.IResolvable): any;
export declare class CognitiveAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CognitiveAccountTimeouts | undefined;
    set internalValue(value: CognitiveAccountTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account azurerm_cognitive_account}
*/
export declare class CognitiveAccount extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account azurerm_cognitive_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CognitiveAccountConfig
    */
    constructor(scope: Construct, id: string, config: CognitiveAccountConfig);
    private _customSubdomainName?;
    get customSubdomainName(): string;
    set customSubdomainName(value: string);
    resetCustomSubdomainName(): void;
    get customSubdomainNameInput(): string | undefined;
    get endpoint(): string;
    private _fqdns?;
    get fqdns(): string[];
    set fqdns(value: string[]);
    resetFqdns(): void;
    get fqdnsInput(): string[] | undefined;
    get id(): string;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _localAuthEnabled?;
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthEnabled(): void;
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _metricsAdvisorAadClientId?;
    get metricsAdvisorAadClientId(): string;
    set metricsAdvisorAadClientId(value: string);
    resetMetricsAdvisorAadClientId(): void;
    get metricsAdvisorAadClientIdInput(): string | undefined;
    private _metricsAdvisorAadTenantId?;
    get metricsAdvisorAadTenantId(): string;
    set metricsAdvisorAadTenantId(value: string);
    resetMetricsAdvisorAadTenantId(): void;
    get metricsAdvisorAadTenantIdInput(): string | undefined;
    private _metricsAdvisorSuperUserName?;
    get metricsAdvisorSuperUserName(): string;
    set metricsAdvisorSuperUserName(value: string);
    resetMetricsAdvisorSuperUserName(): void;
    get metricsAdvisorSuperUserNameInput(): string | undefined;
    private _metricsAdvisorWebsiteName?;
    get metricsAdvisorWebsiteName(): string;
    set metricsAdvisorWebsiteName(value: string);
    resetMetricsAdvisorWebsiteName(): void;
    get metricsAdvisorWebsiteNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _outboundNetworkAccessRestrited?;
    get outboundNetworkAccessRestrited(): boolean | cdktf.IResolvable;
    set outboundNetworkAccessRestrited(value: boolean | cdktf.IResolvable);
    resetOutboundNetworkAccessRestrited(): void;
    get outboundNetworkAccessRestritedInput(): boolean | cdktf.IResolvable | undefined;
    get primaryAccessKey(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _qnaRuntimeEndpoint?;
    get qnaRuntimeEndpoint(): string;
    set qnaRuntimeEndpoint(value: string);
    resetQnaRuntimeEndpoint(): void;
    get qnaRuntimeEndpointInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): CognitiveAccountIdentityOutputReference;
    putIdentity(value: CognitiveAccountIdentity): void;
    resetIdentity(): void;
    get identityInput(): CognitiveAccountIdentity | undefined;
    private _networkAcls;
    get networkAcls(): CognitiveAccountNetworkAclsOutputReference;
    putNetworkAcls(value: CognitiveAccountNetworkAcls): void;
    resetNetworkAcls(): void;
    get networkAclsInput(): CognitiveAccountNetworkAcls | undefined;
    private _storage?;
    get storage(): CognitiveAccountStorage[] | cdktf.IResolvable;
    set storage(value: CognitiveAccountStorage[] | cdktf.IResolvable);
    resetStorage(): void;
    get storageInput(): cdktf.IResolvable | CognitiveAccountStorage[] | undefined;
    private _timeouts;
    get timeouts(): CognitiveAccountTimeoutsOutputReference;
    putTimeouts(value: CognitiveAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CognitiveAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
