import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApiManagementApiVersionSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set#api_management_name DataAzurermApiManagementApiVersionSet#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set#name DataAzurermApiManagementApiVersionSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set#resource_group_name DataAzurermApiManagementApiVersionSet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set#timeouts DataAzurermApiManagementApiVersionSet#timeouts}
    */
    readonly timeouts?: DataAzurermApiManagementApiVersionSetTimeouts;
}
export interface DataAzurermApiManagementApiVersionSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set#read DataAzurermApiManagementApiVersionSet#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApiManagementApiVersionSetTimeoutsToTerraform(struct?: DataAzurermApiManagementApiVersionSetTimeoutsOutputReference | DataAzurermApiManagementApiVersionSetTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApiManagementApiVersionSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermApiManagementApiVersionSetTimeouts | undefined;
    set internalValue(value: DataAzurermApiManagementApiVersionSetTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set azurerm_api_management_api_version_set}
*/
export declare class DataAzurermApiManagementApiVersionSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api_version_set azurerm_api_management_api_version_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApiManagementApiVersionSetConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementApiVersionSetConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    get description(): string;
    get displayName(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get versionHeaderName(): string;
    get versionQueryName(): string;
    get versioningScheme(): string;
    private _timeouts;
    get timeouts(): DataAzurermApiManagementApiVersionSetTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApiManagementApiVersionSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermApiManagementApiVersionSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
