import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppServiceCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate#name DataAzurermAppServiceCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate#resource_group_name DataAzurermAppServiceCertificate#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate#tags DataAzurermAppServiceCertificate#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate#timeouts DataAzurermAppServiceCertificate#timeouts}
    */
    readonly timeouts?: DataAzurermAppServiceCertificateTimeouts;
}
export interface DataAzurermAppServiceCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate#read DataAzurermAppServiceCertificate#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppServiceCertificateTimeoutsToTerraform(struct?: DataAzurermAppServiceCertificateTimeoutsOutputReference | DataAzurermAppServiceCertificateTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppServiceCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAppServiceCertificateTimeouts | undefined;
    set internalValue(value: DataAzurermAppServiceCertificateTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate azurerm_app_service_certificate}
*/
export declare class DataAzurermAppServiceCertificate extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate azurerm_app_service_certificate} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppServiceCertificateConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppServiceCertificateConfig);
    get expirationDate(): string;
    get friendlyName(): string;
    get hostNames(): string[];
    get id(): string;
    get issueDate(): string;
    get issuer(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get subjectName(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get thumbprint(): string;
    private _timeouts;
    get timeouts(): DataAzurermAppServiceCertificateTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppServiceCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAppServiceCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
