import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service#name DataAzurermAppService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service#resource_group_name DataAzurermAppService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service#timeouts DataAzurermAppService#timeouts}
    */
    readonly timeouts?: DataAzurermAppServiceTimeouts;
}
export declare class DataAzurermAppServiceConnectionString extends cdktf.ComplexComputedList {
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class DataAzurermAppServiceSiteConfigCors extends cdktf.ComplexComputedList {
    get allowedOrigins(): string[];
    get supportCredentials(): cdktf.IResolvable;
}
export declare class DataAzurermAppServiceSiteConfigIpRestrictionHeaders extends cdktf.ComplexComputedList {
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermAppServiceSiteConfigIpRestriction extends cdktf.ComplexComputedList {
    get action(): string;
    get headers(): cdktf.IResolvable;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermAppServiceSiteConfigScmIpRestrictionHeaders extends cdktf.ComplexComputedList {
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermAppServiceSiteConfigScmIpRestriction extends cdktf.ComplexComputedList {
    get action(): string;
    get headers(): cdktf.IResolvable;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermAppServiceSiteConfig extends cdktf.ComplexComputedList {
    get acrUseManagedIdentityCredentials(): cdktf.IResolvable;
    get acrUserManagedIdentityClientId(): string;
    get alwaysOn(): cdktf.IResolvable;
    get appCommandLine(): string;
    get cors(): cdktf.IResolvable;
    get defaultDocuments(): string[];
    get dotnetFrameworkVersion(): string;
    get ftpsState(): string;
    get healthCheckPath(): string;
    get http2Enabled(): cdktf.IResolvable;
    get ipRestriction(): cdktf.IResolvable;
    get javaContainer(): string;
    get javaContainerVersion(): string;
    get javaVersion(): string;
    get linuxFxVersion(): string;
    get localMysqlEnabled(): cdktf.IResolvable;
    get managedPipelineMode(): string;
    get minTlsVersion(): string;
    get numberOfWorkers(): number;
    get phpVersion(): string;
    get pythonVersion(): string;
    get remoteDebuggingEnabled(): cdktf.IResolvable;
    get remoteDebuggingVersion(): string;
    get scmIpRestriction(): cdktf.IResolvable;
    get scmType(): string;
    get scmUseMainIpRestriction(): cdktf.IResolvable;
    get use32BitWorkerProcess(): cdktf.IResolvable;
    get vnetRouteAllEnabled(): cdktf.IResolvable;
    get websocketsEnabled(): cdktf.IResolvable;
    get windowsFxVersion(): string;
}
export declare class DataAzurermAppServiceSiteCredential extends cdktf.ComplexComputedList {
    get password(): string;
    get username(): string;
}
export declare class DataAzurermAppServiceSourceControl extends cdktf.ComplexComputedList {
    get branch(): string;
    get manualIntegration(): cdktf.IResolvable;
    get repoUrl(): string;
    get rollbackEnabled(): cdktf.IResolvable;
    get useMercurial(): cdktf.IResolvable;
}
export interface DataAzurermAppServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service#read DataAzurermAppService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppServiceTimeoutsToTerraform(struct?: DataAzurermAppServiceTimeoutsOutputReference | DataAzurermAppServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAppServiceTimeouts | undefined;
    set internalValue(value: DataAzurermAppServiceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_service azurerm_app_service}
*/
export declare class DataAzurermAppService extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_service azurerm_app_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppServiceConfig);
    get appServicePlanId(): string;
    appSettings(key: string): string | cdktf.IResolvable;
    get clientAffinityEnabled(): cdktf.IResolvable;
    get clientCertEnabled(): cdktf.IResolvable;
    connectionString(index: string): DataAzurermAppServiceConnectionString;
    get customDomainVerificationId(): string;
    get defaultSiteHostname(): string;
    get enabled(): cdktf.IResolvable;
    get httpsOnly(): cdktf.IResolvable;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    siteConfig(index: string): DataAzurermAppServiceSiteConfig;
    siteCredential(index: string): DataAzurermAppServiceSiteCredential;
    sourceControl(index: string): DataAzurermAppServiceSourceControl;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermAppServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAppServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
