import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApplicationGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_gateway#name DataAzurermApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_gateway#resource_group_name DataAzurermApplicationGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_gateway#timeouts DataAzurermApplicationGateway#timeouts}
    */
    readonly timeouts?: DataAzurermApplicationGatewayTimeouts;
}
export declare class DataAzurermApplicationGatewayIdentity extends cdktf.ComplexComputedList {
    get identityIds(): string[];
    get type(): string;
}
export interface DataAzurermApplicationGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_gateway#read DataAzurermApplicationGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApplicationGatewayTimeoutsToTerraform(struct?: DataAzurermApplicationGatewayTimeoutsOutputReference | DataAzurermApplicationGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApplicationGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermApplicationGatewayTimeouts | undefined;
    set internalValue(value: DataAzurermApplicationGatewayTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/application_gateway azurerm_application_gateway}
*/
export declare class DataAzurermApplicationGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/application_gateway azurerm_application_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApplicationGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApplicationGatewayConfig);
    get id(): string;
    identity(index: string): DataAzurermApplicationGatewayIdentity;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermApplicationGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApplicationGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermApplicationGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
