import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAutomationVariableIntConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_int#automation_account_name DataAzurermAutomationVariableInt#automation_account_name}
    */
    readonly automationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_int#name DataAzurermAutomationVariableInt#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_int#resource_group_name DataAzurermAutomationVariableInt#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_int#timeouts DataAzurermAutomationVariableInt#timeouts}
    */
    readonly timeouts?: DataAzurermAutomationVariableIntTimeouts;
}
export interface DataAzurermAutomationVariableIntTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_int#read DataAzurermAutomationVariableInt#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAutomationVariableIntTimeoutsToTerraform(struct?: DataAzurermAutomationVariableIntTimeoutsOutputReference | DataAzurermAutomationVariableIntTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAutomationVariableIntTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAutomationVariableIntTimeouts | undefined;
    set internalValue(value: DataAzurermAutomationVariableIntTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_int azurerm_automation_variable_int}
*/
export declare class DataAzurermAutomationVariableInt extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_int azurerm_automation_variable_int} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAutomationVariableIntConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAutomationVariableIntConfig);
    private _automationAccountName?;
    get automationAccountName(): string;
    set automationAccountName(value: string);
    get automationAccountNameInput(): string | undefined;
    get description(): string;
    get encrypted(): cdktf.IResolvable;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get value(): number;
    private _timeouts;
    get timeouts(): DataAzurermAutomationVariableIntTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAutomationVariableIntTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAutomationVariableIntTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
