import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAvailabilitySetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/availability_set#name DataAzurermAvailabilitySet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/availability_set#resource_group_name DataAzurermAvailabilitySet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/availability_set#timeouts DataAzurermAvailabilitySet#timeouts}
    */
    readonly timeouts?: DataAzurermAvailabilitySetTimeouts;
}
export interface DataAzurermAvailabilitySetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/availability_set#read DataAzurermAvailabilitySet#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAvailabilitySetTimeoutsToTerraform(struct?: DataAzurermAvailabilitySetTimeoutsOutputReference | DataAzurermAvailabilitySetTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAvailabilitySetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAvailabilitySetTimeouts | undefined;
    set internalValue(value: DataAzurermAvailabilitySetTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/availability_set azurerm_availability_set}
*/
export declare class DataAzurermAvailabilitySet extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/availability_set azurerm_availability_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAvailabilitySetConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAvailabilitySetConfig);
    get id(): string;
    get location(): string;
    get managed(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get platformFaultDomainCount(): string;
    get platformUpdateDomainCount(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermAvailabilitySetTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAvailabilitySetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAvailabilitySetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
