import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBatchPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool#account_name DataAzurermBatchPool#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool#name DataAzurermBatchPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool#resource_group_name DataAzurermBatchPool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool#timeouts DataAzurermBatchPool#timeouts}
    */
    readonly timeouts?: DataAzurermBatchPoolTimeouts;
}
export declare class DataAzurermBatchPoolAutoScale extends cdktf.ComplexComputedList {
    get evaluationInterval(): string;
    get formula(): string;
}
export declare class DataAzurermBatchPoolCertificate extends cdktf.ComplexComputedList {
    get id(): string;
    get storeLocation(): string;
    get storeName(): string;
    get visibility(): string[];
}
export declare class DataAzurermBatchPoolContainerConfigurationContainerRegistries extends cdktf.ComplexComputedList {
    get password(): string;
    get registryServer(): string;
    get userName(): string;
}
export declare class DataAzurermBatchPoolContainerConfiguration extends cdktf.ComplexComputedList {
    get containerImageNames(): string[];
    get containerRegistries(): cdktf.IResolvable;
    get type(): string;
}
export declare class DataAzurermBatchPoolFixedScale extends cdktf.ComplexComputedList {
    get resizeTimeout(): string;
    get targetDedicatedNodes(): number;
    get targetLowPriorityNodes(): number;
}
export declare class DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules extends cdktf.ComplexComputedList {
    get access(): string;
    get priority(): number;
    get sourceAddressPrefix(): string;
}
export declare class DataAzurermBatchPoolNetworkConfigurationEndpointConfiguration extends cdktf.ComplexComputedList {
    get backendPort(): number;
    get frontendPortRange(): string;
    get name(): string;
    get networkSecurityGroupRules(): cdktf.IResolvable;
    get protocol(): string;
}
export declare class DataAzurermBatchPoolNetworkConfiguration extends cdktf.ComplexComputedList {
    get endpointConfiguration(): cdktf.IResolvable;
    get subnetId(): string;
}
export declare class DataAzurermBatchPoolStartTaskResourceFile extends cdktf.ComplexComputedList {
    get autoStorageContainerName(): string;
    get blobPrefix(): string;
    get fileMode(): string;
    get filePath(): string;
    get httpUrl(): string;
    get storageContainerUrl(): string;
}
export declare class DataAzurermBatchPoolStartTaskUserIdentityAutoUser extends cdktf.ComplexComputedList {
    get elevationLevel(): string;
    get scope(): string;
}
export declare class DataAzurermBatchPoolStartTaskUserIdentity extends cdktf.ComplexComputedList {
    get autoUser(): cdktf.IResolvable;
    get userName(): string;
}
export declare class DataAzurermBatchPoolStartTask extends cdktf.ComplexComputedList {
    get commandLine(): string;
    get commonEnvironmentProperties(): {
        [key: string]: string;
    };
    get environment(): {
        [key: string]: string;
    };
    get maxTaskRetryCount(): number;
    get resourceFile(): cdktf.IResolvable;
    get taskRetryMaximum(): number;
    get userIdentity(): cdktf.IResolvable;
    get waitForSuccess(): cdktf.IResolvable;
}
export declare class DataAzurermBatchPoolStorageImageReference extends cdktf.ComplexComputedList {
    get id(): string;
    get offer(): string;
    get publisher(): string;
    get sku(): string;
    get version(): string;
}
export interface DataAzurermBatchPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool#read DataAzurermBatchPool#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBatchPoolTimeoutsToTerraform(struct?: DataAzurermBatchPoolTimeoutsOutputReference | DataAzurermBatchPoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBatchPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermBatchPoolTimeouts | undefined;
    set internalValue(value: DataAzurermBatchPoolTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool azurerm_batch_pool}
*/
export declare class DataAzurermBatchPool extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool azurerm_batch_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBatchPoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBatchPoolConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    autoScale(index: string): DataAzurermBatchPoolAutoScale;
    certificate(index: string): DataAzurermBatchPoolCertificate;
    containerConfiguration(index: string): DataAzurermBatchPoolContainerConfiguration;
    get displayName(): string;
    fixedScale(index: string): DataAzurermBatchPoolFixedScale;
    get id(): string;
    get maxTasksPerNode(): number;
    metadata(key: string): string | cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    networkConfiguration(index: string): DataAzurermBatchPoolNetworkConfiguration;
    get nodeAgentSkuId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    startTask(index: string): DataAzurermBatchPoolStartTask;
    storageImageReference(index: string): DataAzurermBatchPoolStorageImageReference;
    get vmSize(): string;
    private _timeouts;
    get timeouts(): DataAzurermBatchPoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBatchPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermBatchPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
