import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBillingMpaAccountScopeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mpa_account_scope#billing_account_name DataAzurermBillingMpaAccountScope#billing_account_name}
    */
    readonly billingAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mpa_account_scope#customer_name DataAzurermBillingMpaAccountScope#customer_name}
    */
    readonly customerName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mpa_account_scope#timeouts DataAzurermBillingMpaAccountScope#timeouts}
    */
    readonly timeouts?: DataAzurermBillingMpaAccountScopeTimeouts;
}
export interface DataAzurermBillingMpaAccountScopeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mpa_account_scope#read DataAzurermBillingMpaAccountScope#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBillingMpaAccountScopeTimeoutsToTerraform(struct?: DataAzurermBillingMpaAccountScopeTimeoutsOutputReference | DataAzurermBillingMpaAccountScopeTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBillingMpaAccountScopeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermBillingMpaAccountScopeTimeouts | undefined;
    set internalValue(value: DataAzurermBillingMpaAccountScopeTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mpa_account_scope azurerm_billing_mpa_account_scope}
*/
export declare class DataAzurermBillingMpaAccountScope extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/billing_mpa_account_scope azurerm_billing_mpa_account_scope} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBillingMpaAccountScopeConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBillingMpaAccountScopeConfig);
    private _billingAccountName?;
    get billingAccountName(): string;
    set billingAccountName(value: string);
    get billingAccountNameInput(): string | undefined;
    private _customerName?;
    get customerName(): string;
    set customerName(value: string);
    get customerNameInput(): string | undefined;
    get id(): string;
    private _timeouts;
    get timeouts(): DataAzurermBillingMpaAccountScopeTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBillingMpaAccountScopeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermBillingMpaAccountScopeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
