import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermCosmosdbMongoDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database#account_name DataAzurermCosmosdbMongoDatabase#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database#name DataAzurermCosmosdbMongoDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database#resource_group_name DataAzurermCosmosdbMongoDatabase#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database#timeouts DataAzurermCosmosdbMongoDatabase#timeouts}
    */
    readonly timeouts?: DataAzurermCosmosdbMongoDatabaseTimeouts;
}
export interface DataAzurermCosmosdbMongoDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database#read DataAzurermCosmosdbMongoDatabase#read}
    */
    readonly read?: string;
}
export declare function dataAzurermCosmosdbMongoDatabaseTimeoutsToTerraform(struct?: DataAzurermCosmosdbMongoDatabaseTimeoutsOutputReference | DataAzurermCosmosdbMongoDatabaseTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermCosmosdbMongoDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermCosmosdbMongoDatabaseTimeouts | undefined;
    set internalValue(value: DataAzurermCosmosdbMongoDatabaseTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database azurerm_cosmosdb_mongo_database}
*/
export declare class DataAzurermCosmosdbMongoDatabase extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database azurerm_cosmosdb_mongo_database} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermCosmosdbMongoDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermCosmosdbMongoDatabaseConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermCosmosdbMongoDatabaseTimeoutsOutputReference;
    putTimeouts(value: DataAzurermCosmosdbMongoDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermCosmosdbMongoDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
