import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataShareDatasetBlobStorageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_blob_storage#data_share_id DataAzurermDataShareDatasetBlobStorage#data_share_id}
    */
    readonly dataShareId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_blob_storage#name DataAzurermDataShareDatasetBlobStorage#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_blob_storage#timeouts DataAzurermDataShareDatasetBlobStorage#timeouts}
    */
    readonly timeouts?: DataAzurermDataShareDatasetBlobStorageTimeouts;
}
export declare class DataAzurermDataShareDatasetBlobStorageStorageAccount extends cdktf.ComplexComputedList {
    get name(): string;
    get resourceGroupName(): string;
    get subscriptionId(): string;
}
export interface DataAzurermDataShareDatasetBlobStorageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_blob_storage#read DataAzurermDataShareDatasetBlobStorage#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataShareDatasetBlobStorageTimeoutsToTerraform(struct?: DataAzurermDataShareDatasetBlobStorageTimeoutsOutputReference | DataAzurermDataShareDatasetBlobStorageTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataShareDatasetBlobStorageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermDataShareDatasetBlobStorageTimeouts | undefined;
    set internalValue(value: DataAzurermDataShareDatasetBlobStorageTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_blob_storage azurerm_data_share_dataset_blob_storage}
*/
export declare class DataAzurermDataShareDatasetBlobStorage extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_blob_storage azurerm_data_share_dataset_blob_storage} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataShareDatasetBlobStorageConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareDatasetBlobStorageConfig);
    get containerName(): string;
    private _dataShareId?;
    get dataShareId(): string;
    set dataShareId(value: string);
    get dataShareIdInput(): string | undefined;
    get displayName(): string;
    get filePath(): string;
    get folderPath(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    storageAccount(index: string): DataAzurermDataShareDatasetBlobStorageStorageAccount;
    private _timeouts;
    get timeouts(): DataAzurermDataShareDatasetBlobStorageTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataShareDatasetBlobStorageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDataShareDatasetBlobStorageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
