import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDevTestVirtualNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network#lab_name DataAzurermDevTestVirtualNetwork#lab_name}
    */
    readonly labName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network#name DataAzurermDevTestVirtualNetwork#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network#resource_group_name DataAzurermDevTestVirtualNetwork#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network#timeouts DataAzurermDevTestVirtualNetwork#timeouts}
    */
    readonly timeouts?: DataAzurermDevTestVirtualNetworkTimeouts;
}
export declare class DataAzurermDevTestVirtualNetworkAllowedSubnets extends cdktf.ComplexComputedList {
    get allowPublicIp(): string;
    get labSubnetName(): string;
    get resourceId(): string;
}
export declare class DataAzurermDevTestVirtualNetworkSubnetOverrides extends cdktf.ComplexComputedList {
    get labSubnetName(): string;
    get resourceId(): string;
    get useInVmCreationPermission(): string;
    get usePublicIpAddressPermission(): string;
    get virtualNetworkPoolName(): string;
}
export interface DataAzurermDevTestVirtualNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network#read DataAzurermDevTestVirtualNetwork#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDevTestVirtualNetworkTimeoutsToTerraform(struct?: DataAzurermDevTestVirtualNetworkTimeoutsOutputReference | DataAzurermDevTestVirtualNetworkTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDevTestVirtualNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermDevTestVirtualNetworkTimeouts | undefined;
    set internalValue(value: DataAzurermDevTestVirtualNetworkTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network azurerm_dev_test_virtual_network}
*/
export declare class DataAzurermDevTestVirtualNetwork extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network azurerm_dev_test_virtual_network} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDevTestVirtualNetworkConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDevTestVirtualNetworkConfig);
    allowedSubnets(index: string): DataAzurermDevTestVirtualNetworkAllowedSubnets;
    get id(): string;
    private _labName?;
    get labName(): string;
    set labName(value: string);
    get labNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    subnetOverrides(index: string): DataAzurermDevTestVirtualNetworkSubnetOverrides;
    get uniqueIdentifier(): string;
    private _timeouts;
    get timeouts(): DataAzurermDevTestVirtualNetworkTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDevTestVirtualNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDevTestVirtualNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
