import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDnsZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dns_zone#name DataAzurermDnsZone#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dns_zone#resource_group_name DataAzurermDnsZone#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dns_zone#timeouts DataAzurermDnsZone#timeouts}
    */
    readonly timeouts?: DataAzurermDnsZoneTimeouts;
}
export interface DataAzurermDnsZoneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dns_zone#read DataAzurermDnsZone#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDnsZoneTimeoutsToTerraform(struct?: DataAzurermDnsZoneTimeoutsOutputReference | DataAzurermDnsZoneTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDnsZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermDnsZoneTimeouts | undefined;
    set internalValue(value: DataAzurermDnsZoneTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/dns_zone azurerm_dns_zone}
*/
export declare class DataAzurermDnsZone extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/dns_zone azurerm_dns_zone} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDnsZoneConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDnsZoneConfig);
    get id(): string;
    get maxNumberOfRecordSets(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nameServers(): string[];
    get numberOfRecordSets(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermDnsZoneTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDnsZoneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDnsZoneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
