import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermIothubDpsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps#name DataAzurermIothubDps#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps#resource_group_name DataAzurermIothubDps#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps#tags DataAzurermIothubDps#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps#timeouts DataAzurermIothubDps#timeouts}
    */
    readonly timeouts?: DataAzurermIothubDpsTimeouts;
}
export interface DataAzurermIothubDpsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps#read DataAzurermIothubDps#read}
    */
    readonly read?: string;
}
export declare function dataAzurermIothubDpsTimeoutsToTerraform(struct?: DataAzurermIothubDpsTimeoutsOutputReference | DataAzurermIothubDpsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermIothubDpsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermIothubDpsTimeouts | undefined;
    set internalValue(value: DataAzurermIothubDpsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps azurerm_iothub_dps}
*/
export declare class DataAzurermIothubDps extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps azurerm_iothub_dps} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermIothubDpsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermIothubDpsConfig);
    get allocationPolicy(): string;
    get deviceProvisioningHostName(): string;
    get id(): string;
    get idScope(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serviceOperationsHostName(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurermIothubDpsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermIothubDpsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermIothubDpsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
