import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermIothubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub#name DataAzurermIothub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub#resource_group_name DataAzurermIothub#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub#tags DataAzurermIothub#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub#timeouts DataAzurermIothub#timeouts}
    */
    readonly timeouts?: DataAzurermIothubTimeouts;
}
export interface DataAzurermIothubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub#read DataAzurermIothub#read}
    */
    readonly read?: string;
}
export declare function dataAzurermIothubTimeoutsToTerraform(struct?: DataAzurermIothubTimeoutsOutputReference | DataAzurermIothubTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermIothubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermIothubTimeouts | undefined;
    set internalValue(value: DataAzurermIothubTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/iothub azurerm_iothub}
*/
export declare class DataAzurermIothub extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/iothub azurerm_iothub} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermIothubConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermIothubConfig);
    get hostname(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurermIothubTimeoutsOutputReference;
    putTimeouts(value: DataAzurermIothubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermIothubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
