import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLbBackendAddressPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_backend_address_pool#loadbalancer_id DataAzurermLbBackendAddressPool#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_backend_address_pool#name DataAzurermLbBackendAddressPool#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_backend_address_pool#timeouts DataAzurermLbBackendAddressPool#timeouts}
    */
    readonly timeouts?: DataAzurermLbBackendAddressPoolTimeouts;
}
export declare class DataAzurermLbBackendAddressPoolBackendAddress extends cdktf.ComplexComputedList {
    get ipAddress(): string;
    get name(): string;
    get virtualNetworkId(): string;
}
export declare class DataAzurermLbBackendAddressPoolBackendIpConfigurations extends cdktf.ComplexComputedList {
    get id(): string;
}
export interface DataAzurermLbBackendAddressPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_backend_address_pool#read DataAzurermLbBackendAddressPool#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLbBackendAddressPoolTimeoutsToTerraform(struct?: DataAzurermLbBackendAddressPoolTimeoutsOutputReference | DataAzurermLbBackendAddressPoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLbBackendAddressPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermLbBackendAddressPoolTimeouts | undefined;
    set internalValue(value: DataAzurermLbBackendAddressPoolTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/lb_backend_address_pool azurerm_lb_backend_address_pool}
*/
export declare class DataAzurermLbBackendAddressPool extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/lb_backend_address_pool azurerm_lb_backend_address_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLbBackendAddressPoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLbBackendAddressPoolConfig);
    backendAddress(index: string): DataAzurermLbBackendAddressPoolBackendAddress;
    backendIpConfigurations(index: string): DataAzurermLbBackendAddressPoolBackendIpConfigurations;
    get id(): string;
    get loadBalancingRules(): string[];
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundRules(): string[];
    private _timeouts;
    get timeouts(): DataAzurermLbBackendAddressPoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLbBackendAddressPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermLbBackendAddressPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
