import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLbRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_rule#loadbalancer_id DataAzurermLbRule#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_rule#name DataAzurermLbRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_rule#resource_group_name DataAzurermLbRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_rule#timeouts DataAzurermLbRule#timeouts}
    */
    readonly timeouts?: DataAzurermLbRuleTimeouts;
}
export interface DataAzurermLbRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_rule#read DataAzurermLbRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLbRuleTimeoutsToTerraform(struct?: DataAzurermLbRuleTimeoutsOutputReference | DataAzurermLbRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLbRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermLbRuleTimeouts | undefined;
    set internalValue(value: DataAzurermLbRuleTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/lb_rule azurerm_lb_rule}
*/
export declare class DataAzurermLbRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/lb_rule azurerm_lb_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLbRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLbRuleConfig);
    get backendAddressPoolId(): string;
    get backendPort(): number;
    get disableOutboundSnat(): cdktf.IResolvable;
    get enableFloatingIp(): cdktf.IResolvable;
    get enableTcpReset(): cdktf.IResolvable;
    get frontendIpConfigurationName(): string;
    get frontendPort(): number;
    get id(): string;
    get idleTimeoutInMinutes(): number;
    get loadDistribution(): string;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get probeId(): string;
    get protocol(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermLbRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLbRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermLbRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
